/*
 * Decompiled with CFR 0.152.
 */
package com.fpx.api.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fpx.api.constants.AmbientEnum;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    public static String get(String url) throws IOException {
        try (CloseableHttpResponse response = null;){
            HttpGet httpGet = new HttpGet(url);
            response = HttpClients.createDefault().execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            JSONObject errorObject = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            String errorMsg = errorObject.getString("message");
            throw new IOException("HTTP ERROR: " + response.getStatusLine().getStatusCode() + "," + errorMsg);
        }
    }

    public static String postJson(String url, Object object) throws IOException {
        String jsonData = JSON.toJSONString((Object)object);
        return HttpClientUtils.post(url, jsonData);
    }

    public static String post(String url, String jsonData) throws IOException {
        CloseableHttpResponse response = null;
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)jsonData)) {
            post.setEntity((HttpEntity)new StringEntity(jsonData, StandardCharsets.UTF_8));
        }
        try {
            response = HttpClients.createDefault().execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                JSONObject errorObject = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                String errorMsg = errorObject.getString("message");
                throw new IOException("HTTP ERROR: " + response.getStatusLine().getStatusCode() + "," + errorMsg);
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage(), e);
        }
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    public static String post(String url, Map<String, Object> params) throws IOException {
        try (CloseableHttpResponse response = null;){
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            if (MapUtils.isNotEmpty(params)) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
            }
            if ((response = HttpClients.createDefault().execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            throw new IOException("HTTP Error:" + response.getStatusLine().getStatusCode());
        }
    }

    public static String getAddress(AmbientEnum ambient) {
        return AmbientEnum.FORMAT_ADDRESS.equals((Object)ambient) ? "https://open.4px.com" : "https://open-test.4px.com";
    }
}

