/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.sql;

import com.beast.face.front.business.enums.CircleTypeEnum;
import com.beast.face.front.business.sql.CircleRuleContent;
import com.beast.face.front.business.sql.CircleSqlEnginee;
import com.beast.face.front.business.sql.factory.CircleCountSqlFactory;
import com.beast.face.front.business.sql.factory.CircleMemberSqlFacotry;
import com.beast.face.front.business.vo.CircleRule;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CircleRuleContainer {
    protected List<CircleRuleContent> ruleContentList;

    private CircleRuleContainer(List<CircleRuleContent> ruleContentList) {
        this.ruleContentList = ruleContentList;
    }

    public List<CircleRuleContent> getRuleContentList() {
        return this.ruleContentList;
    }

    public static CircleRuleContainer createRuleContainer(List<CircleRuleContent> ruleContentList) {
        return new CircleRuleContainer(ruleContentList);
    }

    public String parseCustomCountSql() {
        if (CollectionUtils.isEmpty(this.ruleContentList)) {
            throw new RuntimeException("\u89c4\u5219\u5185\u5bb9\u96c6\u5408\u4e3a\u7a7a");
        }
        CircleCountSqlFactory abstrctFactory = new CircleCountSqlFactory();
        CircleSqlEnginee sqlEnginee = new CircleSqlEnginee(this.ruleContentList, abstrctFactory);
        return sqlEnginee.generaterFinalSql();
    }

    public String parseCondtionSql() {
        CircleCountSqlFactory abstrctFactory = new CircleCountSqlFactory();
        CircleSqlEnginee sqlEnginee = new CircleSqlEnginee(this.ruleContentList, abstrctFactory);
        return sqlEnginee.generaterCondtionSql();
    }

    public String parseCustomMemberSql() {
        if (CollectionUtils.isEmpty(this.ruleContentList)) {
            throw new RuntimeException("\u89c4\u5219\u5185\u5bb9\u96c6\u5408\u4e3a\u7a7a");
        }
        CircleMemberSqlFacotry abstrctFactory = new CircleMemberSqlFacotry();
        CircleSqlEnginee sqlEnginee = new CircleSqlEnginee(this.ruleContentList, abstrctFactory);
        return sqlEnginee.generaterFinalSql();
    }

    public CircleTypeEnum getCircleType() {
        ArrayList circleId = Lists.newArrayList();
        ArrayList labelIds = Lists.newArrayList();
        for (CircleRuleContent ruleContent : this.ruleContentList) {
            for (CircleRule circleRule : ruleContent.getCircleRules()) {
                if (circleRule.getCircleId() != null) {
                    circleId.add(circleRule.getCircleId());
                    continue;
                }
                if (circleRule.getLabelId() == null) continue;
                labelIds.add(circleRule.getLabelId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds) && CollectionUtils.isNotEmpty((Collection)circleId)) {
            return CircleTypeEnum.LABEL_PEOPLE;
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            return CircleTypeEnum.LABEL;
        }
        if (CollectionUtils.isNotEmpty((Collection)circleId)) {
            return CircleTypeEnum.PEOPLE;
        }
        throw new RuntimeException("unknow circle type");
    }
}

