/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.beast.face.front.business.cond.CircleLabelCond;
import com.beast.face.front.business.convert.CircleConvert;
import com.beast.face.front.business.enums.QueryTypeEnum;
import com.beast.face.front.business.service.CircleLabelService;
import com.beast.face.front.business.sql.CircleRuleContainer;
import com.beast.face.front.business.sql.CircleRuleContent;
import com.beast.face.front.business.vo.CircleLableVO;
import com.beast.face.front.business.vo.CircleRule;
import com.beast.face.front.business.vo.CrowdVO;
import com.beast.face.front.business.vo.circle.CircleRecordVO;
import com.beast.face.front.dao.clickhouse.mapper.custom.FaceCustomMapper;
import com.beast.face.front.dao.mysql.mapper.meta.CircleLabelMapper;
import com.beast.face.front.dao.mysql.mapper.meta.MetaLabelMapper;
import com.beast.face.front.dao.mysql.mapper.meta.custom.CircleLabelCustomMapper;
import com.beast.face.front.dao.mysql.po.meta.CircleLabelExample;
import com.beast.face.front.dao.mysql.po.meta.CircleLabelPageExample;
import com.beast.face.front.dao.mysql.po.meta.CircleLabelWithBLOBs;
import com.beast.face.front.dao.mysql.po.meta.MetaLabel;
import com.beast.face.front.dao.mysql.po.meta.MetaLabelExample;
import com.google.common.collect.Lists;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.utils.BeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CircleLabelServiceImpl
implements CircleLabelService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    MetaLabelMapper metaLabelMapper;
    @Autowired
    CircleLabelMapper circleLabelMapper;
    @Autowired
    CircleLabelCustomMapper circleLabelCustomMapper;
    @Autowired
    FaceCustomMapper faceCustomMapper;

    private List<CircleRuleContent> getCircleRuleContents(CrowdVO crowd) {
        LinkedList ruleContentList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(crowd.getInterRules())) {
            ruleContentList.add(CircleRuleContent.newInstance(QueryTypeEnum.INTER.getCode(), crowd.getInterRules()));
        }
        if (CollectionUtils.isNotEmpty(crowd.getUnionRules())) {
            ruleContentList.add(CircleRuleContent.newInstance(QueryTypeEnum.UNION.getCode(), crowd.getUnionRules()));
        }
        if (CollectionUtils.isNotEmpty(crowd.getDiffRules())) {
            ruleContentList.add(CircleRuleContent.newInstance(QueryTypeEnum.DIFF.getCode(), crowd.getDiffRules()));
        }
        return ruleContentList;
    }

    private Map<Integer, MetaLabel> queryCircleRuleDetail(List<CircleRuleContent> ruleContentList) {
        ArrayList labelIdList = Lists.newArrayList();
        for (CircleRuleContent ruleContent : ruleContentList) {
            Iterator<CircleRule> it = ruleContent.getCircleRules().iterator();
            while (it.hasNext()) {
                Integer labelId = it.next().getLabelId();
                if (labelId == null) continue;
                labelIdList.add(labelId);
            }
        }
        MetaLabelExample labelExample = new MetaLabelExample();
        labelExample.createCriteria().andIsValidEqualTo(Boolean.valueOf(true)).andLabelIdIn((List)labelIdList);
        List labelList = this.metaLabelMapper.selectByExample(labelExample);
        return labelList.stream().collect(Collectors.toMap(MetaLabel::getLabelId, Function.identity()));
    }

    @Override
    public PageQueryResp<CircleRecordVO> pageQuery(CircleLabelCond cond) {
        PageQueryResp pageResp = new PageQueryResp();
        CircleLabelExample example = new CircleLabelExample();
        example.createCriteria().andIsValidEqualTo(Boolean.TRUE);
        Long total = this.circleLabelMapper.countByExample(example);
        List circleLabels = Lists.newArrayList();
        if (total > 0L) {
            CircleLabelPageExample pageExample = new CircleLabelPageExample(example, cond.getOffset(), cond.getPagenum());
            example.setOrderByClause("id desc");
            circleLabels = this.circleLabelCustomMapper.selectByExampleForPage(pageExample);
        }
        pageResp.setBeanList(CircleConvert.convertCircleLabel2RecordVo(circleLabels));
        pageResp.setOffset(cond.getOffset());
        pageResp.setPageSize(cond.getPagenum());
        pageResp.setTotalCnt(Integer.valueOf(total.intValue()));
        return pageResp;
    }

    @Override
    public CrowdVO getInfoById(Integer circleId) {
        CircleLabelWithBLOBs record = this.circleLabelMapper.selectByPrimaryKey(circleId);
        if (record == null) {
            this.logger.warn("\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55:" + circleId);
            return null;
        }
        List ruleContents = JSONArray.parseArray((String)record.getCircleRule(), CircleRuleContent.class);
        CrowdVO crowd = new CrowdVO();
        crowd.setCircleId(record.getCircleId());
        crowd.setCircleName(record.getCircleName());
        ruleContents.forEach(ruleContent -> {
            if (QueryTypeEnum.INTER.getCode().equals(ruleContent.getQueryType())) {
                crowd.setInterRules(ruleContent.getCircleRules());
            }
            if (QueryTypeEnum.UNION.getCode().equals(ruleContent.getQueryType())) {
                crowd.setUnionRules(ruleContent.getCircleRules());
            }
            if (QueryTypeEnum.DIFF.getCode().equals(ruleContent.getQueryType())) {
                crowd.setDiffRules(ruleContent.getCircleRules());
            }
        });
        return crowd;
    }

    @Override
    public Boolean removeCircle(Integer circleId) {
        CircleLabelWithBLOBs circleLabel = new CircleLabelWithBLOBs();
        circleLabel.setCircleId(circleId);
        circleLabel.setIsValid(Boolean.valueOf(false));
        int num = this.circleLabelMapper.updateByPrimaryKeySelective(circleLabel);
        return num == 1;
    }

    @Override
    public List<CircleLableVO> queryAll() {
        CircleLabelExample example = new CircleLabelExample();
        example.createCriteria().andIsValidEqualTo(Boolean.valueOf(true));
        List circleLabels = this.circleLabelMapper.selectByExample(example);
        return BeanUtil.buildListFrom((Collection)circleLabels, CircleLableVO.class);
    }

    @Override
    public List<CircleLableVO> likeByName(String name) {
        CircleLabelExample example = new CircleLabelExample();
        example.createCriteria().andIsValidEqualTo(Boolean.valueOf(true)).andCircleNameLike('%' + name + '%');
        List circleLabels = this.circleLabelMapper.selectByExample(example);
        return BeanUtil.buildListFrom((Collection)circleLabels, CircleLableVO.class);
    }

    @Override
    public int countPeople(CrowdVO crowd) {
        this.logger.info("\u4eba\u7fa4\u7edf\u8ba1,data={}", (Object)crowd);
        List<CircleRuleContent> ruleContentList = this.getCircleRuleContents(crowd);
        CircleRuleContainer ruleContainer = CircleRuleContainer.createRuleContainer(ruleContentList);
        String customSql = ruleContainer.parseCustomCountSql();
        int count = this.faceCustomMapper.countByCustomSql(customSql);
        this.logger.info("\u4eba\u7fa4\u7edf\u8ba1,count={}", (Object)count);
        return count;
    }

    @Override
    public void circlePeople(CrowdVO crowd) {
        this.logger.info("\u4eba\u7fa4\u5708\u9009,data={}", (Object)crowd);
        List<CircleRuleContent> ruleContentList = this.getCircleRuleContents(crowd);
        CircleRuleContainer ruleContainer = CircleRuleContainer.createRuleContainer(ruleContentList);
        String customSql = ruleContainer.parseCustomCountSql();
        int count = this.faceCustomMapper.countByCustomSql(customSql);
        this.logger.info("\u4eba\u7fa4\u5708\u9009,count={}", (Object)count);
        CircleLableVO circleLableVO = new CircleLableVO();
        circleLableVO.setCircleName(crowd.getCircleName());
        circleLableVO.setCircleType(ruleContainer.getCircleType().getCode());
        circleLableVO.setCircleRule(JSON.toJSONString(ruleContainer.getRuleContentList()));
        circleLableVO.setCircleNum(count);
        this.circleLabelMapper.insertSelective((CircleLabelWithBLOBs)BeanUtil.buildFrom((Object)circleLableVO, CircleLabelWithBLOBs.class));
    }

    @Override
    public List<Map<String, Object>> getExportPeople(CrowdVO crowd) {
        List ruleContentList;
        this.logger.info("\u4eba\u7fa4\u5bfc\u51fa,data={}", (Object)crowd);
        if (crowd.getCircleId() != null) {
            CircleLabelWithBLOBs record = this.circleLabelMapper.selectByPrimaryKey(crowd.getCircleId());
            ruleContentList = JSON.parseArray((String)record.getCircleRule(), CircleRuleContent.class);
            crowd.setCircleName(record.getCircleName());
        } else {
            ruleContentList = this.getCircleRuleContents(crowd);
        }
        CircleRuleContainer ruleContainer = CircleRuleContainer.createRuleContainer(ruleContentList);
        String customSql = ruleContainer.parseCustomMemberSql();
        List memberList = this.faceCustomMapper.selectMemberByCustomSql(customSql);
        this.logger.info("\u5bfc\u51fa\u4eba\u7fa4,size={}", (Object)memberList.size());
        return memberList;
    }
}

