/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.auth;

import com.alibaba.fastjson.JSONObject;
import com.beast.face.front.business.exception.AuthorizedException;
import com.thebeastshop.kit.prop.PropConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);
    private static final String COOKEE_TOKEN_NAME = "portalToken";
    private static final String SSO_TOKEN_PASS = "sso.token.pass";
    private static final String SSO_TOKEN_VERIFYURL = "sso.token.verifyUrl";
    @Autowired
    RestTemplate restTemplate;

    private String getSSOTokey(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!COOKEE_TOKEN_NAME.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if ("true".equals(PropConfig.getProperties((String)SSO_TOKEN_PASS))) {
            return true;
        }
        String ssoToken = this.getSSOTokey(request);
        if (StringUtils.isBlank((String)ssoToken)) {
            throw new AuthorizedException();
        }
        String verifyUrl = PropConfig.getProperties((String)SSO_TOKEN_VERIFYURL);
        if (StringUtils.isBlank((String)verifyUrl)) {
            throw new RuntimeException("miss verify config");
        }
        String requestPath = verifyUrl.concat("?access_token=").concat(ssoToken);
        JSONObject reponse = (JSONObject)this.restTemplate.getForObject(requestPath, JSONObject.class, new Object[0]);
        Boolean tokenValid = reponse.getBoolean("success");
        if (BooleanUtils.isNotTrue((Boolean)tokenValid)) {
            throw new AuthorizedException();
        }
        return true;
    }
}

