/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.controller;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.beast.face.front.business.cond.CircleLabelCond;
import com.beast.face.front.business.result.Result;
import com.beast.face.front.business.result.ResultCode;
import com.beast.face.front.business.result.ResultSupport;
import com.beast.face.front.business.service.CircleLabelService;
import com.beast.face.front.business.service.MetadataService;
import com.beast.face.front.business.utils.CsvExportUtil;
import com.beast.face.front.business.vo.CircleLableVO;
import com.beast.face.front.business.vo.CrowdVO;
import com.beast.face.front.business.vo.SidebarVO;
import com.beast.face.front.business.vo.ThemeTreeVO;
import com.beast.face.front.business.vo.circle.CircleRecordVO;
import com.google.common.collect.Lists;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.exception.ValidationException;
import com.thebeastshop.kit.redis.util.RedisClient;
import io.swagger.annotations.Api;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="/\u4eba\u7fa4\u5708\u9009")
@RequestMapping(value={"/crowd"})
public class CrowdController {
    private static Logger logger = LoggerFactory.getLogger(CrowdController.class);
    private static final String EXPIRE_KEY_PRE = "face_expire_";
    @Autowired
    MetadataService metadataService;
    @Autowired
    CircleLabelService circleLabelService;
    @Autowired
    RedisClient redisClient;

    @GetMapping(value={"/list"})
    public Result list(CircleLabelCond cond) {
        PageQueryResp<CircleRecordVO> pageQueryResp = this.circleLabelService.pageQuery(cond);
        return ResultSupport.ok(pageQueryResp);
    }

    @GetMapping(value={"/detail"})
    public Result circleDetail(@RequestParam(value="circleId") Integer circleId) {
        CrowdVO crowd = this.circleLabelService.getInfoById(circleId);
        return ResultSupport.ok(crowd);
    }

    @PutMapping(value={"/delete"})
    public Result deleteCircle(@RequestParam(value="circleId") Integer circleId) {
        Boolean success = this.circleLabelService.removeCircle(circleId);
        return ResultSupport.ok(success);
    }

    @GetMapping(value={"/sidebar"})
    public Result sidebar() {
        List<ThemeTreeVO> themeTreeVOS = this.metadataService.getCategoryLabelTree();
        List<CircleLableVO> circleLableVOS = this.circleLabelService.queryAll();
        return ResultSupport.ok(new SidebarVO(themeTreeVOS, circleLableVOS));
    }

    @PostMapping(value={"/count"})
    public Result count(@RequestBody CrowdVO crowd) {
        logger.info("\u4eba\u7fa4\u7edf\u8ba1,data=" + JSON.toJSONString((Object)crowd));
        int count = this.circleLabelService.countPeople(crowd);
        return ResultSupport.ok(count);
    }

    @PostMapping(value={"/create"})
    public Result create(@RequestBody CrowdVO crowd) {
        logger.info("\u4eba\u7fa4\u5708\u9009,data=" + JSON.toJSONString((Object)crowd));
        if (crowd.getCircleId() != null) {
            this.circleLabelService.removeCircle(crowd.getCircleId());
        }
        this.circleLabelService.circlePeople(crowd);
        return ResultSupport.ok();
    }

    @PostMapping(value={"/preExport"})
    public Result preExport(@RequestBody CrowdVO crowdVO) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(crowdVO.toString().getBytes());
            String mdKey = new BigInteger(1, md.digest()).toString(16);
            this.redisClient.putCache(EXPIRE_KEY_PRE.concat(mdKey), (Object)crowdVO, Long.valueOf(6L), TimeUnit.HOURS);
            return ResultSupport.ok(mdKey);
        }
        catch (Exception e) {
            return ResultSupport.error(ResultCode.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/export"})
    public void export(@RequestParam(value="mdKey") String mdKey, HttpServletResponse response) {
        try {
            CrowdVO crowdVO = (CrowdVO)this.redisClient.getCache(EXPIRE_KEY_PRE.concat(mdKey));
            if (crowdVO == null) {
                throw new ValidationException("\u5bfc\u51fa\u4fe1\u606f\u65e0\u6548");
            }
            List<Integer> memberIds = this.circleLabelService.getExportPeople(crowdVO);
            if (CollectionUtils.isEmpty(memberIds)) {
                throw new ValidationException("\u6ca1\u6709\u5339\u914d\u7684\u4eba\u7fa4");
            }
            String[] titles = new String[]{"memberId"};
            ArrayList dataList = Lists.newArrayList();
            memberIds.forEach(memberId -> {
                String[] data = new String[]{String.valueOf(memberId)};
                dataList.add(data);
            });
            String fileName = StringUtils.isBlank((String)crowdVO.getCircleName()) ? "\u4eba\u7fa4\u5bfc\u51fa" : crowdVO.getCircleName();
            File file = CsvExportUtil.makeTempCSV(fileName, titles, dataList);
            CsvExportUtil.downloadFile(response, file);
            boolean filedel = file.delete();
            logger.info("\u6587\u4ef6\u5220\u9664:" + (filedel ? "\u6210\u529f" : "\u5931\u8d25"));
            this.redisClient.delCache(EXPIRE_KEY_PRE.concat(mdKey));
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            throw new ValidationException("\u5bfc\u51fa\u5931\u8d25");
        }
    }
}

