/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.controller;

import com.beast.face.front.business.convert.CircleConvert;
import com.beast.face.front.business.result.Result;
import com.beast.face.front.business.result.ResultSupport;
import com.beast.face.front.dao.mysql.mapper.meta.CircleLabelMapper;
import com.beast.face.front.dao.mysql.mapper.meta.custom.CircleLabelCustomMapper;
import com.beast.face.front.dao.mysql.po.meta.CircleLabelExample;
import com.beast.face.front.dao.mysql.po.meta.CircleLabelPageExample;
import com.beast.face.front.dao.mysql.po.meta.CircleLabelWithBLOBs;
import com.thebeastshop.common.PageQueryResp;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class CirclePeopleController {
    private static Logger logger = LoggerFactory.getLogger(CirclePeopleController.class);
    @Autowired
    CircleLabelMapper circleLabelMapper;
    @Autowired
    CircleLabelCustomMapper circleLabelCustomMapper;

    @GetMapping(value={"/list"})
    public Result list(@RequestParam(value="offset", defaultValue="0") Integer offset, @RequestParam(value="limit", defaultValue="20") Integer limit) {
        PageQueryResp pageResp = new PageQueryResp();
        pageResp.setOffset(Integer.valueOf(0));
        pageResp.setPageSize(Integer.valueOf(20));
        CircleLabelExample example = new CircleLabelExample();
        example.createCriteria().andIsValidEqualTo(Boolean.TRUE);
        Long total = this.circleLabelMapper.countByExample(example);
        if (total > 0L) {
            example.setOrderByClause("id desc");
            List circleLabels = this.circleLabelCustomMapper.selectByExampleForPage(new CircleLabelPageExample(example, offset, limit));
            pageResp.setBeanList(CircleConvert.convertCircleLabel2RecordVo(circleLabels));
        }
        pageResp.setTotalCnt(Integer.valueOf(total.intValue()));
        return ResultSupport.ok(pageResp);
    }

    @GetMapping(value={"/{circleId}/detail"})
    public Result circleDetail(@PathVariable Integer circleId) {
        CircleLabelWithBLOBs circleLabelWithBLOBs = this.circleLabelMapper.selectByPrimaryKey(circleId);
        return ResultSupport.ok(circleLabelWithBLOBs);
    }

    @PutMapping(value={"/{circleId}/delete"})
    public Result deleteCircle(@PathVariable Integer circleId) {
        CircleLabelWithBLOBs circleLabelWithBLOBs = this.circleLabelMapper.selectByPrimaryKey(circleId);
        return ResultSupport.ok(circleLabelWithBLOBs);
    }

    @PostMapping(value={"/save"})
    public Result createCircle(@RequestBody Integer circleId) {
        CircleLabelWithBLOBs circleLabelWithBLOBs = this.circleLabelMapper.selectByPrimaryKey(circleId);
        return ResultSupport.ok(circleLabelWithBLOBs);
    }
}

