/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business;

import com.beast.face.front.business.exception.AuthorizedException;
import com.beast.face.front.business.result.Result;
import com.beast.face.front.business.result.ResultCode;
import com.beast.face.front.business.result.ResultSupport;
import com.thebeastshop.common.exception.ValidationException;
import com.thebeastshop.kit.prop.PropConstants;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionAdvice {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Result> handleBadRequestException(ValidationException ex) {
        this.logger.warn(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)ResultSupport.bad_request(ex.getMessage()), HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<Result> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException ex) {
        this.logger.warn(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)ResultSupport.method_not_allowed(), HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity<Result> handleHttpMediaTypeNotAcceptableException(HttpMediaTypeNotAcceptableException ex) {
        this.logger.warn(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)ResultSupport.not_acceptable(), HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseEntity<Result> handleHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException ex) {
        this.logger.warn(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)ResultSupport.unsupported_media_type(), HttpStatus.OK);
    }

    @ExceptionHandler(value={AuthorizedException.class})
    public ResponseEntity<Result> handleUnauthorizedException(AuthorizedException ex) {
        this.logger.warn(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)ResultSupport.unauthorized(ex.getMessage()), HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Result> handleException(Exception ex) {
        this.logger.warn(ex.getMessage(), (Throwable)ex);
        String env = PropConstants.getEnv((Properties)System.getProperties());
        if (env.equals("pro")) {
            return new ResponseEntity((Object)ResultSupport.error(ResultCode.INTERNAL_SERVER_ERROR), HttpStatus.OK);
        }
        return new ResponseEntity((Object)new Result(ResultCode.INTERNAL_SERVER_ERROR.getCode(), ex.getMessage()), HttpStatus.OK);
    }
}

