/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.service.impl;

import com.beast.face.front.business.service.MetadataService;
import com.beast.face.front.business.service.UserLabelService;
import com.beast.face.front.business.vo.UserLabelVO;
import com.beast.face.front.dao.clickhouse.mapper.FaceMapper;
import com.beast.face.front.dao.mysql.po.meta.MetaCategory;
import com.beast.face.front.dao.mysql.po.meta.MetaLabel;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserLabelServiceImpl
implements UserLabelService {
    @Autowired
    FaceMapper faceMapper;
    @Autowired
    MetadataService metadataService;

    @Override
    public Map<Integer, List<UserLabelVO>> queryUserLabel(Integer memberId) {
        HashMap<Integer, List<UserLabelVO>> labelMap = new HashMap<Integer, List<UserLabelVO>>();
        Map faceRow = this.faceMapper.selectByMemberCode(memberId);
        if (MapUtils.isEmpty((Map)faceRow)) {
            return labelMap;
        }
        HashMap<Integer, MetaCategory> categoryMap = new HashMap<Integer, MetaCategory>();
        List<MetaCategory> categories = this.metadataService.getAllCategory();
        for (MetaCategory category : categories) {
            categoryMap.put(category.getCategoryId(), category);
        }
        List<MetaLabel> metaLabels = this.metadataService.getAllLabel();
        for (MetaLabel metaLabel : metaLabels) {
            UserLabelVO userLabelVO = new UserLabelVO();
            userLabelVO.setLabelId(metaLabel.getLabelId());
            userLabelVO.setLabelName(metaLabel.getLabelName());
            userLabelVO.setLabelDesc(metaLabel.getLabelDesc());
            String labelValueStr = (String)faceRow.get("label_id_" + metaLabel.getLabelId());
            if (StringUtils.isBlank((CharSequence)labelValueStr)) {
                labelValueStr = "";
                continue;
            }
            userLabelVO.setLabelValues(Lists.newArrayList((Object[])StringUtils.split((String)labelValueStr, (char)',')));
            Integer themeId = ((MetaCategory)categoryMap.get(metaLabel.getCategoryId())).getThemeId();
            if (labelMap.containsKey(themeId)) {
                ((List)labelMap.get(themeId)).add(userLabelVO);
                continue;
            }
            labelMap.put(themeId, Lists.newArrayList((Object[])new UserLabelVO[]{userLabelVO}));
        }
        return labelMap;
    }
}

