/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.auth;

import com.alibaba.fastjson.JSONObject;
import com.beast.face.front.business.exception.AuthorizedException;
import com.thebeastshop.common.spring.SpringAware;
import com.thebeastshop.kit.prop.PropConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthInterceptor
implements HandlerInterceptor {
    private final String COOKEE_TOKEN_NAME = "portalToken";
    private final String SSO_TOKEN_PASS = "sso.token.pass";
    private final String SSO_TOKEN_VERIFYURL = "sso.token.verifyUrl";
    private static final Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);

    private String getSSOTokey(HttpServletRequest request) {
        for (Cookie cookie : request.getCookies()) {
            if (!"portalToken".equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!"true".equals(PropConfig.getProperties((String)"sso.token.pass"))) {
            return true;
        }
        String ssoToken = this.getSSOTokey(request);
        logger.info("ssoToken = " + ssoToken);
        if (StringUtils.isBlank((String)ssoToken)) {
            throw new AuthorizedException();
        }
        String verifyUrl = PropConfig.getProperties((String)"sso.token.verifyUrl");
        if (StringUtils.isBlank((String)verifyUrl)) {
            throw new RuntimeException("miss verify config");
        }
        String requestPath = verifyUrl.concat("?access_token=").concat(ssoToken);
        RestTemplate restTemplate = (RestTemplate)SpringAware.getBean(RestTemplate.class);
        JSONObject reponse = (JSONObject)restTemplate.getForObject(requestPath, JSONObject.class, new Object[0]);
        Boolean tokenValid = reponse.getBoolean("success");
        if (BooleanUtils.isNotTrue((Boolean)tokenValid)) {
            throw new AuthorizedException();
        }
        return true;
    }
}

