/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.sql.generate;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BaseSqlGenerate {
    protected String stringEquals(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" = ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String stringNotEquals(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" <> ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String stringIn(String column, List<String> values) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" IN (");
        Iterator<String> iterator = values.iterator();
        ArrayList newValues = Lists.newArrayList();
        while (iterator.hasNext()) {
            newValues.add("'" + iterator.next() + "'");
        }
        builder.append(Joiner.on((String)",").join((Iterable)newValues)).append(")");
        return builder.toString();
    }

    protected String stringLike(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" LIKE ").append("'%").append(value).append("%'");
        return builder.toString();
    }

    protected String stringNotLike(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" NOT LIKE ").append("'%").append(value).append("%'");
        return builder.toString();
    }

    protected String stringStartWith(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" LIKE ").append("'").append(value).append("%'");
        return builder.toString();
    }

    protected String stringEndWith(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" LIKE ").append("'%").append(value).append("'");
        return builder.toString();
    }

    protected String numberIn(String column, List<Number> numbers) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        stringBuilder.append(column).append(" IN ").append("(");
        stringBuilder.append(Joiner.on((String)",").join(numbers.iterator())).append(")");
        return stringBuilder.toString();
    }

    protected String numberEquals(String column, Number value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" = ").append(value);
        return builder.toString();
    }

    protected String numberNotEquals(String column, Number value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" <> ").append(value);
        return builder.toString();
    }

    protected String numberLt(String column, Number value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" < ").append(value);
        return builder.toString();
    }

    protected String numberLtEquals(String column, Number value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" <= ").append(value);
        return builder.toString();
    }

    protected String numberGt(String column, Number value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" > ").append(value);
        return builder.toString();
    }

    protected String numberGtEquals(String column, Number value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" >= ").append(value);
        return builder.toString();
    }

    protected String numberBetween(String column, Number begin, Number end) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" >= ").append(begin).append(" ").append(" < ").append(end);
        return builder.toString();
    }

    protected String dateEquals(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" = ").append(value);
        return builder.toString();
    }

    protected String dateNotEquals(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" <> ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String dateGtEquals(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" >= ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String dateGt(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" > ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String dateLtEquals(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" <= ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String dateLt(String column, String value) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" < ").append("'").append(value).append("'");
        return builder.toString();
    }

    protected String dateBetween(String column, String begin, String end) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(column).append(" >= ").append(begin).append(" ").append(" < ").append(end);
        return builder.toString();
    }
}

