/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.sql.handler;

import com.beast.face.front.business.enums.QueryTypeEnum;
import com.beast.face.front.business.sql.CircleRuleContent;
import com.beast.face.front.business.sql.CircleSqlFragment;
import com.beast.face.front.business.sql.context.CircleRuleParserContext;
import com.beast.face.front.business.sql.handler.CircleDiffSqlHandler;
import com.beast.face.front.business.sql.handler.CircleInterSqlHandler;
import com.beast.face.front.business.sql.handler.CircleUnionSqlHandler;
import com.beast.face.front.business.vo.CircleRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CircleSqlHandler {
    protected static final String SUB_QUERY_PRE = "SELECT member_id FROM face WHERE";
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Boolean isFirst = true;
    protected CircleRuleContent circleRuleContent;
    private CircleSqlHandler nextSqlHandler;

    public Boolean getFirst() {
        return this.isFirst;
    }

    public void setFirst(Boolean first) {
        this.isFirst = first;
    }

    public CircleSqlHandler getNextSqlHandler() {
        return this.nextSqlHandler;
    }

    public void addSqlHandlerLast(CircleSqlHandler nextSqlHandler) {
        CircleSqlHandler circleSqlHandler = this;
        while (circleSqlHandler.nextSqlHandler != null) {
            circleSqlHandler = circleSqlHandler.nextSqlHandler;
        }
        nextSqlHandler.setFirst(false);
        circleSqlHandler.nextSqlHandler = nextSqlHandler;
    }

    public CircleSqlHandler(CircleRuleContent circleRuleContent) {
        this.circleRuleContent = circleRuleContent;
    }

    protected abstract String appendPrefix();

    public String createSubQuerySql() {
        QueryTypeEnum queryTypeEnum = QueryTypeEnum.getEnumByCode(this.circleRuleContent.getQueryType());
        this.logger.info("\u89e3\u6790\u5f53\u524d[{}]\u67e5\u8be2\u89c4\u5219", (Object)queryTypeEnum.getName());
        CircleSqlFragment sqlFragment = null;
        for (CircleRule circleRule : this.circleRuleContent.getCircleRules()) {
            String circleType = circleRule.getCircleType().getCode();
            String ruleSql = CircleRuleParserContext.getRuleParser(circleType).parseRuleToSql(circleRule);
            if (ruleSql == null) continue;
            if (sqlFragment == null) {
                sqlFragment = new CircleSqlFragment(null, ruleSql);
                continue;
            }
            sqlFragment.addSqlFragmetLast(new CircleSqlFragment(queryTypeEnum.getSymbol(), ruleSql));
        }
        String subQuerySql = "\n" + this.appendPrefix() + " (" + SUB_QUERY_PRE + sqlFragment.joinSql() + ")";
        this.logger.info("{}\u6761\u4ef6\uff1a{}", (Object)queryTypeEnum.getName(), (Object)subQuerySql.replaceAll("\n", ""));
        CircleSqlHandler nextSqlHandler = this.getNextSqlHandler();
        if (nextSqlHandler != null) {
            subQuerySql = subQuerySql + nextSqlHandler.createSubQuerySql();
        }
        return subQuerySql;
    }

    public static CircleSqlHandler createSqlHandler(CircleRuleContent circleRuleContent) {
        if (QueryTypeEnum.INTER.getCode().equals(circleRuleContent.getQueryType())) {
            return new CircleInterSqlHandler(circleRuleContent);
        }
        if (QueryTypeEnum.UNION.getCode().equals(circleRuleContent.getQueryType())) {
            return new CircleUnionSqlHandler(circleRuleContent);
        }
        if (QueryTypeEnum.DIFF.getCode().equals(circleRuleContent.getQueryType())) {
            return new CircleDiffSqlHandler(circleRuleContent);
        }
        throw new RuntimeException("\u4ea4\u5e76\u5dee\u7c7b\u578b\u5f02\u5e38");
    }
}

