/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.service.impl;

import com.beast.face.front.business.service.MetadataService;
import com.beast.face.front.business.vo.EditCategory;
import com.beast.face.front.business.vo.EditLabel;
import com.beast.face.front.business.vo.MetaCategoryTreeVO;
import com.beast.face.front.business.vo.MetaLabelVO;
import com.beast.face.front.business.vo.NewCategory;
import com.beast.face.front.business.vo.NewLabel;
import com.beast.face.front.business.vo.ThemeTreeVO;
import com.beast.face.front.dao.mysql.mapper.meta.MetaCategoryMapper;
import com.beast.face.front.dao.mysql.mapper.meta.MetaLabelMapper;
import com.beast.face.front.dao.mysql.mapper.meta.MetaThemeMapper;
import com.beast.face.front.dao.mysql.po.meta.MetaCategory;
import com.beast.face.front.dao.mysql.po.meta.MetaCategoryExample;
import com.beast.face.front.dao.mysql.po.meta.MetaLabel;
import com.beast.face.front.dao.mysql.po.meta.MetaLabelExample;
import com.beast.face.front.dao.mysql.po.meta.MetaTheme;
import com.beast.face.front.dao.mysql.po.meta.MetaThemeExample;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataServiceImpl
implements MetadataService {
    @Autowired
    MetaThemeMapper themeMapper;
    @Autowired
    MetaCategoryMapper metaCategoryMapper;
    @Autowired
    MetaLabelMapper metaLabelMapper;

    @Override
    public List<ThemeTreeVO> getCategoryTree() {
        List<MetaTheme> themes = this.getAllTheme();
        List<MetaCategory> categories = this.getAllCategory();
        ArrayList categoryTree = Lists.newArrayList();
        Map<Integer, List<MetaCategoryTreeVO>> foldMetaCategory = this.foldMetaCategory(categories);
        for (MetaTheme value : themes) {
            ThemeTreeVO themeVO = new ThemeTreeVO();
            themeVO.setThemeId(value.getThemeId());
            themeVO.setThemeName(value.getThemeName());
            themeVO.setCategories(foldMetaCategory.get(themeVO.getThemeId()));
            categoryTree.add(themeVO);
        }
        return categoryTree;
    }

    @Override
    public List<ThemeTreeVO> getCategoryLabelTree() {
        List<MetaTheme> themes = this.getAllTheme();
        List<MetaCategory> categories = this.getAllCategory();
        List<MetaLabel> labels = this.getAllLabel();
        ArrayList categoryTree = Lists.newArrayList();
        Map<Integer, List<MetaCategoryTreeVO>> foldMetaCategory = this.foldMetaLabelCategory(categories, labels);
        for (MetaTheme value : themes) {
            ThemeTreeVO themeVO = new ThemeTreeVO();
            themeVO.setThemeId(value.getThemeId());
            themeVO.setThemeName(value.getThemeName());
            themeVO.setCategories(foldMetaCategory.get(themeVO.getThemeId()));
            categoryTree.add(themeVO);
        }
        return categoryTree;
    }

    @Override
    public Integer createCategory(NewCategory newCategory) {
        MetaCategory metaCategory = new MetaCategory();
        metaCategory.setThemeId(newCategory.getThemeId());
        metaCategory.setCategoryName(newCategory.getCategoryName());
        if (newCategory.getParentId() != null) {
            metaCategory.setParentId(newCategory.getParentId());
        }
        metaCategory.setSort(Integer.valueOf(999));
        this.metaCategoryMapper.insertSelective(metaCategory);
        return metaCategory.getCategoryId();
    }

    @Override
    public Boolean editCategory(EditCategory newCategory) {
        MetaCategory metaCategory = new MetaCategory();
        metaCategory.setCategoryId(newCategory.getCategoryId());
        metaCategory.setCategoryName(newCategory.getCategoryName());
        this.metaCategoryMapper.updateByPrimaryKeySelective(metaCategory);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteCategory(Integer categoryId) {
        MetaCategory metaCategory = new MetaCategory();
        metaCategory.setCategoryId(categoryId);
        metaCategory.setIsValid(Boolean.FALSE);
        this.metaCategoryMapper.updateByPrimaryKeySelective(metaCategory);
        return Boolean.TRUE;
    }

    @Override
    public Integer createLabel(NewLabel newLabel) {
        MetaLabel metaLabel = new MetaLabel();
        metaLabel.setLabelName(newLabel.getLabelName());
        metaLabel.setLabelType(newLabel.getLabelType());
        String labelSelectValue = "";
        if (CollectionUtils.isNotEmpty(newLabel.getSelectValues())) {
            labelSelectValue = StringUtils.join(newLabel.getSelectValues(), (String)",");
        }
        metaLabel.setLabelSelectValue(labelSelectValue);
        metaLabel.setCategoryId(newLabel.getCategoryId());
        metaLabel.setDataSource(newLabel.getDataSource());
        metaLabel.setDtsTable(newLabel.getDtsTable());
        metaLabel.setLabelDesc(newLabel.getLabelDesc());
        metaLabel.setIsActive(newLabel.getActive());
        metaLabel.setRemark(newLabel.getRemark());
        this.metaLabelMapper.insertSelective(metaLabel);
        return metaLabel.getLabelId();
    }

    @Override
    public Boolean editLabel(EditLabel editLabel) {
        MetaLabel metaLabel = new MetaLabel();
        metaLabel.setLabelId(editLabel.getLabelId());
        metaLabel.setLabelName(editLabel.getLabelName());
        metaLabel.setLabelType(editLabel.getLabelType());
        String labelSelectValue = "";
        if (CollectionUtils.isNotEmpty(editLabel.getSelectValues())) {
            labelSelectValue = StringUtils.join(editLabel.getSelectValues(), (String)",");
        }
        metaLabel.setLabelSelectValue(labelSelectValue);
        metaLabel.setCategoryId(editLabel.getCategoryId());
        metaLabel.setDataSource(editLabel.getDataSource());
        metaLabel.setDtsTable(editLabel.getDtsTable());
        metaLabel.setLabelDesc(editLabel.getLabelDesc());
        metaLabel.setIsActive(editLabel.getActive());
        metaLabel.setRemark(editLabel.getRemark());
        this.metaLabelMapper.updateByPrimaryKeySelective(metaLabel);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteLabel(Integer labelId) {
        MetaLabel metaLabel = new MetaLabel();
        metaLabel.setLabelId(labelId);
        metaLabel.setIsValid(Boolean.FALSE);
        this.metaLabelMapper.updateByPrimaryKeySelective(metaLabel);
        return Boolean.TRUE;
    }

    private Map<Integer, List<MetaLabelVO>> convertCategoryLabelMap(List<MetaLabel> labels) {
        HashMap categoryLabelMap = Maps.newHashMap();
        for (MetaLabel metaLabel : labels) {
            List labelList;
            MetaLabelVO metaLabelVO = new MetaLabelVO();
            metaLabelVO.setCategoryId(metaLabel.getCategoryId());
            metaLabelVO.setLabelId(metaLabel.getLabelId());
            metaLabelVO.setLabelName(metaLabel.getLabelName());
            metaLabelVO.setLabelType(metaLabel.getLabelType());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaLabel.getLabelSelectValue()})) {
                metaLabelVO.setLabelSelectValues(Splitter.on((String)",").splitToList((CharSequence)metaLabel.getLabelSelectValue()));
            }
            if (categoryLabelMap.containsKey(metaLabel.getCategoryId())) {
                labelList = (List)categoryLabelMap.get(metaLabel.getCategoryId());
                labelList.add(metaLabelVO);
                continue;
            }
            labelList = Lists.newArrayList((Object[])new MetaLabelVO[]{metaLabelVO});
            categoryLabelMap.put(metaLabel.getCategoryId(), labelList);
        }
        return categoryLabelMap;
    }

    private Map<Integer, List<MetaCategoryTreeVO>> foldMetaLabelCategory(List<MetaCategory> categories, List<MetaLabel> labels) {
        ArrayList rootCategories = Lists.newArrayList();
        HashMap<Integer, List<MetaCategory>> parentNodeMap = new HashMap<Integer, List<MetaCategory>>();
        for (MetaCategory category : categories) {
            if (null == category.getParentId() || 0 == category.getParentId()) {
                rootCategories.add(category);
                continue;
            }
            if (parentNodeMap.containsKey(category.getParentId())) {
                ((List)parentNodeMap.get(category.getParentId())).add(category);
                continue;
            }
            parentNodeMap.put(category.getParentId(), Lists.newArrayList((Object[])new MetaCategory[]{category}));
        }
        Map<Integer, List<MetaLabelVO>> categoryLabelMap = this.convertCategoryLabelMap(labels);
        HashMap<Integer, List<MetaCategoryTreeVO>> rootNodeMapKeyThemeId = new HashMap<Integer, List<MetaCategoryTreeVO>>();
        if (CollectionUtils.isNotEmpty((Collection)rootCategories)) {
            for (MetaCategory rootCategory : rootCategories) {
                MetaCategoryTreeVO metaCategoryVO = new MetaCategoryTreeVO();
                metaCategoryVO.setCategoryId(rootCategory.getCategoryId());
                metaCategoryVO.setCategoryName(rootCategory.getCategoryName());
                metaCategoryVO.setChildren(this.getChildrenNode(rootCategory.getCategoryId(), parentNodeMap));
                metaCategoryVO.setMetaLabels(categoryLabelMap.get(rootCategory.getCategoryId()));
                if (rootNodeMapKeyThemeId.containsKey(rootCategory.getThemeId())) {
                    ((List)rootNodeMapKeyThemeId.get(rootCategory.getThemeId())).add(metaCategoryVO);
                    continue;
                }
                rootNodeMapKeyThemeId.put(rootCategory.getThemeId(), Lists.newArrayList((Object[])new MetaCategoryTreeVO[]{metaCategoryVO}));
            }
        }
        return rootNodeMapKeyThemeId;
    }

    private Map<Integer, List<MetaCategoryTreeVO>> foldMetaCategory(List<MetaCategory> categories) {
        ArrayList rootCategories = Lists.newArrayList();
        HashMap<Integer, List<MetaCategory>> parentNodeMap = new HashMap<Integer, List<MetaCategory>>();
        for (MetaCategory category : categories) {
            if (null == category.getParentId() || 0 == category.getParentId()) {
                rootCategories.add(category);
                continue;
            }
            if (parentNodeMap.containsKey(category.getParentId())) {
                ((List)parentNodeMap.get(category.getParentId())).add(category);
                continue;
            }
            parentNodeMap.put(category.getParentId(), Lists.newArrayList((Object[])new MetaCategory[]{category}));
        }
        HashMap<Integer, List<MetaCategoryTreeVO>> rootNodeMapKeyThemeId = new HashMap<Integer, List<MetaCategoryTreeVO>>();
        if (CollectionUtils.isNotEmpty((Collection)rootCategories)) {
            for (MetaCategory rootCategory : rootCategories) {
                MetaCategoryTreeVO metaCategoryVO = new MetaCategoryTreeVO();
                metaCategoryVO.setCategoryId(rootCategory.getCategoryId());
                metaCategoryVO.setCategoryName(rootCategory.getCategoryName());
                metaCategoryVO.setChildren(this.getChildrenNode(rootCategory.getCategoryId(), parentNodeMap));
                if (rootNodeMapKeyThemeId.containsKey(rootCategory.getThemeId())) {
                    ((List)rootNodeMapKeyThemeId.get(rootCategory.getThemeId())).add(metaCategoryVO);
                    continue;
                }
                rootNodeMapKeyThemeId.put(rootCategory.getThemeId(), Lists.newArrayList((Object[])new MetaCategoryTreeVO[]{metaCategoryVO}));
            }
        }
        return rootNodeMapKeyThemeId;
    }

    private List<MetaCategoryTreeVO> getChildrenNode(Integer rootId, Map<Integer, List<MetaCategory>> nodeMap) {
        ArrayList targetNodes = Lists.newArrayList();
        List<MetaCategory> childNodes = nodeMap.get(rootId);
        if (CollectionUtils.isNotEmpty(childNodes)) {
            for (MetaCategory node : childNodes) {
                MetaCategoryTreeVO targetNode = new MetaCategoryTreeVO();
                targetNode.setCategoryId(node.getCategoryId());
                targetNode.setCategoryName(node.getCategoryName());
                targetNode.setChildren(this.getChildrenNode(node.getCategoryId(), nodeMap));
                targetNodes.add(targetNode);
            }
        }
        return targetNodes;
    }

    @Override
    public List<MetaLabel> getAllLabel() {
        MetaLabelExample example = new MetaLabelExample();
        example.createCriteria().andIsValidEqualTo(Boolean.TRUE);
        List labels = this.metaLabelMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)labels)) {
            labels = Lists.newArrayList();
        }
        return labels;
    }

    @Override
    public List<MetaTheme> getAllTheme() {
        MetaThemeExample example = new MetaThemeExample();
        example.createCriteria().andIsValidEqualTo(Boolean.TRUE);
        example.setOrderByClause("sort desc");
        List metaThemes = this.themeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)metaThemes)) {
            metaThemes = Lists.newArrayList();
        }
        return metaThemes;
    }

    @Override
    public List<MetaCategory> getAllCategory() {
        MetaCategoryExample example = new MetaCategoryExample();
        example.createCriteria().andIsValidEqualTo(Boolean.TRUE);
        example.setOrderByClause("sort desc");
        List categories = this.metaCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)categories)) {
            categories = Lists.newArrayList();
        }
        return categories;
    }
}

