/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.handler;

import com.beast.face.front.dao.mysql.po.meta.MetaLabel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SqlJoinHandler {
    private String columnTemplate = "WM_CONCAT(',', CASE B.id_field WHEN 'label_id_%s' THEN B.value_field ELSE NULL END) label_id_%d";
    private String tableTemplate = "SELECT ref_field,value_field,'label_id_%s' id_field FROM %s";
    private String sqlTemplate = "SELECT B.REF_FIELD,\n%s \nFROM(\n%s) B GROUP BY B.REF_FIELD;";
    private List<MetaLabel> metaLabelList;

    private SqlJoinHandler(List<MetaLabel> metaLabelList) {
        this.metaLabelList = metaLabelList;
    }

    public static SqlJoinHandler newInstance(List<MetaLabel> metaLabelList) {
        return new SqlJoinHandler(metaLabelList);
    }

    public String joinShuYunSql() {
        ArrayList columns = Lists.newArrayList();
        ArrayList tables = Lists.newArrayList();
        for (MetaLabel label : this.metaLabelList) {
            columns.add(String.format(this.columnTemplate, label.getLabelId(), label.getLabelId()));
            tables.add(String.format(this.tableTemplate, label.getLabelId(), label.getDtsTable()));
        }
        String columnsSql = StringUtils.join((Object[])columns.toArray(), (String)", \n");
        String tablesSql = StringUtils.join((Object[])tables.toArray(), (String)" UNION ALL \n");
        return String.format(this.sqlTemplate, columnsSql, tablesSql);
    }
}

