/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.convert;

import com.beast.face.front.business.vo.MetaLabelVO;
import com.beast.face.front.dao.mysql.po.meta.MetaCategory;
import com.beast.face.front.dao.mysql.po.meta.MetaLabel;
import com.beast.face.front.dao.mysql.po.meta.MetaTheme;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class LabelConvert {
    public static List<MetaLabelVO> convert4MetalLabel(List<MetaLabel> sources, List<MetaTheme> themes, List<MetaCategory> categories) {
        ArrayList targets = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sources)) {
            HashMap<Integer, MetaTheme> themeMap = new HashMap<Integer, MetaTheme>();
            for (MetaTheme theme : themes) {
                themeMap.put(theme.getThemeId(), theme);
            }
            HashMap<Integer, MetaCategory> categoryMap = new HashMap<Integer, MetaCategory>();
            for (MetaCategory category : categories) {
                categoryMap.put(category.getCategoryId(), category);
            }
            for (MetaLabel label : sources) {
                MetaLabelVO labelVO = new MetaLabelVO();
                BeanUtils.copyProperties((Object)label, (Object)labelVO);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{label.getLabelSelectValue()})) {
                    labelVO.setLabelSelectValues(Lists.newArrayList((Object[])StringUtils.split((String)label.getLabelSelectValue(), (char)',')));
                }
                labelVO.setDataSourceName("\u6570\u4e91");
                labelVO.setLabelTypeName("\u5b57\u7b26\u9009\u62e9");
                MetaCategory metaCategory = (MetaCategory)categoryMap.get(label.getCategoryId());
                MetaTheme metaTheme = (MetaTheme)themeMap.get(metaCategory.getThemeId());
                labelVO.setThemeId(metaTheme.getThemeId());
                labelVO.setThemeName(metaTheme.getThemeName());
                labelVO.setLabelId(label.getLabelId());
                labelVO.setLabelName(label.getLabelName());
                targets.add(labelVO);
            }
        }
        return targets;
    }
}

