/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.controller;

import com.beast.face.front.business.result.Result;
import com.beast.face.front.business.result.ResultSupport;
import com.beast.face.front.business.service.MetadataService;
import com.beast.face.front.business.service.UserLabelService;
import com.beast.face.front.business.vo.UserLabelVO;
import com.beast.face.front.dao.clickhouse.mapper.FaceMapper;
import com.beast.face.front.dao.mysql.po.meta.MetaTheme;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="/\u7528\u6237\u6807\u7b7eController")
@RequestMapping(value={"/user/label"})
public class UserLabelController {
    private static Logger logger = LoggerFactory.getLogger(UserLabelController.class);
    @Autowired
    FaceMapper faceMapper;
    @Autowired
    UserLabelService userLabelService;
    @Autowired
    MetadataService metadataService;

    @GetMapping(value={"{memberId}"})
    private Result getUserLabel(@PathVariable Integer memberId) {
        ArrayList resultMap = Lists.newArrayList();
        if (null == memberId || memberId == 0) {
            return ResultSupport.bad_request("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<MetaTheme> themes = this.metadataService.getAllTheme();
        HashMap<Integer, String> themeMap = new HashMap<Integer, String>();
        for (MetaTheme theme : themes) {
            themeMap.put(theme.getThemeId(), theme.getThemeName());
        }
        Map<Integer, List<UserLabelVO>> labelMap = this.userLabelService.queryUserLabel(memberId);
        if (MapUtils.isNotEmpty(labelMap)) {
            for (Map.Entry<Integer, List<UserLabelVO>> entry : labelMap.entrySet()) {
                HashMap<String, Object> themeVoMap = new HashMap<String, Object>();
                themeVoMap.put("themeId", entry.getKey());
                themeVoMap.put("themeName", themeMap.get(entry.getKey()));
                themeVoMap.put("labels", entry.getValue());
                resultMap.add(themeVoMap);
            }
        }
        return ResultSupport.ok(resultMap);
    }
}

