/*
 * Decompiled with CFR 0.152.
 */
package com.beast.face.front.business.controller;

import com.beast.face.front.business.controller.HeartBeatController;
import com.beast.face.front.business.result.Result;
import com.beast.face.front.business.result.ResultSupport;
import com.beast.face.front.business.service.MetadataLabelService;
import com.beast.face.front.business.service.MetadataService;
import com.beast.face.front.business.vo.EditCategory;
import com.beast.face.front.business.vo.EditLabel;
import com.beast.face.front.business.vo.MetaLabelVO;
import com.beast.face.front.business.vo.NewCategory;
import com.beast.face.front.business.vo.NewLabel;
import com.beast.face.front.business.vo.ThemeTreeVO;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.validation.Validation;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="/\u5143\u6570\u636eController")
@RequestMapping(value={"/metadata"})
public class MetadataController {
    private static Logger logger = LoggerFactory.getLogger(HeartBeatController.class);
    @Autowired
    MetadataService metadataService;
    @Autowired
    MetadataLabelService metadataLabelService;

    @GetMapping(value={"/category/all"})
    public Result getCategoryList() {
        List<ThemeTreeVO> themeVOS = this.metadataService.getCategoryTree();
        logger.info("\u67e5\u8be2\u7c7b\u76ee\u6811\uff0c\u8282\u70b9\u6570:" + themeVOS.size());
        return ResultSupport.ok(themeVOS);
    }

    @PostMapping(value={"/category"})
    public Result createCategory(@RequestBody NewCategory category) {
        Validation.assertNotNull((Object)category, (String)"\u521b\u5efa\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        Validation.assertNotNull((Object)category.getThemeId(), (String)"\u4e3b\u9898Id\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        Validation.assertNotNull((Object)category.getCategoryName(), (String)"\u6807\u7b7e\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        Integer categoryId = this.metadataService.createCategory(category);
        logger.info("\u521b\u5efa\u6210\u529f\uff1aid=" + categoryId);
        return ResultSupport.ok(categoryId);
    }

    @PutMapping(value={"/category/{categoryId}"})
    public Result editCategoryName(@PathVariable Integer categoryId, @RequestBody EditCategory editCategory) {
        Validation.assertNotNull((Object)editCategory, (String)"\u521b\u5efa\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        Validation.assertNotNull((Object)editCategory.getCategoryName(), (String)"\u6807\u7b7e\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        editCategory.setCategoryId(categoryId);
        Boolean flag = this.metadataService.editCategory(editCategory);
        logger.info("\u7f16\u8f91\u6807\u7b7e\u7c7b\u76ee: {} Result = {}", (Object)editCategory, (Object)flag);
        return ResultSupport.ok(flag);
    }

    @DeleteMapping(value={"/category/{categoryId}"})
    public Result deleteCategory(@PathVariable Integer categoryId) {
        Boolean flag = this.metadataService.deleteCategory(categoryId);
        logger.info("\u5220\u9664\u6807\u7b7e\u7c7b\u76ee: id = {} Result = {}", (Object)categoryId, (Object)flag);
        return ResultSupport.ok(flag);
    }

    @GetMapping(value={"/label/all"})
    public Result getLabelList(@RequestParam(value="offset", defaultValue="0") Integer offset, @RequestParam(value="limit", defaultValue="20") Integer limit) {
        PageQueryResp<MetaLabelVO> labelVOS = this.metadataLabelService.queryMetadataLabelByPage(null, offset, limit);
        logger.info("\u67e5\u8be2\u6807\u7b7e\u5217\u8868\u6210\u529f\uff0c\u5171\u8ba1:" + labelVOS.getTotalCnt());
        return ResultSupport.ok(labelVOS);
    }

    @GetMapping(value={"/label/{categoryId}"})
    public Result getLabelsByCategoryId(@PathVariable Integer categoryId, @RequestParam(value="offset", defaultValue="0") Integer offset, @RequestParam(value="limit", defaultValue="20") Integer limit) {
        PageQueryResp<MetaLabelVO> labelVOS = this.metadataLabelService.queryMetadataLabelByPage(categoryId, offset, limit);
        logger.info("\u67e5\u8be2\u6807\u7b7e\u5217\u8868\u6210\u529f\uff0c\u5171\u8ba1:" + labelVOS.getTotalCnt());
        return ResultSupport.ok(labelVOS);
    }

    @PostMapping(value={"/label"})
    public Result createLabel(@RequestBody NewLabel newLabel) {
        if (newLabel == null) {
            return ResultSupport.bad_request("\u521b\u5efa\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        Validation.assertNotNull((Object)newLabel, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Validation.assertNotNull((Object)newLabel.getCategoryId(), (String)"\u6807\u7b7e\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Validation.assertNotNull((Object)newLabel.getLabelName(), (String)"\u6807\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Validation.assertNotNull((Object)newLabel.getLabelType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Validation.assertNotNull((Object)newLabel.getDataSource(), (String)"\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        Integer labelId = this.metadataService.createLabel(newLabel);
        logger.info("\u521b\u5efa \u5165\u53c2\uff1a{} result \uff1a{}", (Object)newLabel, (Object)labelId);
        return ResultSupport.ok(labelId);
    }

    @PutMapping(value={"/label/{labelId}"})
    public Result editLabel(@PathVariable Integer labelId, @RequestBody EditLabel editLabel) {
        Validation.assertNotNull((Object)editLabel, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Validation.assertNotNull((Object)editLabel.getLabelId(), (String)"\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a");
        editLabel.setLabelId(labelId);
        Boolean flag = this.metadataService.editLabel(editLabel);
        logger.info("\u7f16\u8f91\u6807\u7b7e\u7c7b\u76ee: {} Result = {}", (Object)editLabel, (Object)flag);
        return ResultSupport.ok(flag);
    }

    @DeleteMapping(value={"/label/{labelId}"})
    public Result deleteLabel(@PathVariable Integer labelId) {
        Boolean flag = this.metadataService.deleteLabel(labelId);
        logger.info("\u5220\u9664\u6807\u7b7e: id = {} Result = {}", (Object)labelId, (Object)flag);
        return ResultSupport.ok(flag);
    }
}

