/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.LogbackException;
import com.beast.clog.agent.log.ILogSender;
import com.beast.clog.agent.log.impl.CLoggingLogSender;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.TraceManager;
import com.beast.clog.common.utils.IdentityUtil;
import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.LogLevel;
import com.beast.clog.models.thrift.LogType;

public class ClogLogBackAppender
extends AppenderBase<ILoggingEvent> {
    ILogSender logSender;

    protected void append(ILoggingEvent event) {
        try {
            ILogSender sender = this.getLogSender();
            if (sender != null) {
                sender.send(this.convertILoggingEvent2LogEvent(event));
            }
        }
        catch (Exception var4) {
            throw new LogbackException(event.getFormattedMessage(), (Throwable)var4);
        }
    }

    private ILogSender getLogSender() {
        if (this.logSender == null) {
            ITrace tracer = TraceManager.getTracer("logback-clog");
            this.logSender = new CLoggingLogSender(tracer);
        }
        return this.logSender;
    }

    private LogEvent convertILoggingEvent2LogEvent(ILoggingEvent event) {
        LogEvent logEvent = new LogEvent();
        logEvent.setId(IdentityUtil.getUniqueID());
        logEvent.setTitle("NA");
        logEvent.setLogLevel(this.convertLevel2LogLevel(event.getLevel()));
        logEvent.setLogType(LogType.APP);
        logEvent.setSource(event.getLoggerName());
        logEvent.setThreadId(Thread.currentThread().getId());
        logEvent.setCreatedTime(event.getTimeStamp());
        logEvent.setAttributes(null);
        logEvent.setMessage(event.getFormattedMessage());
        ThrowableProxy info = (ThrowableProxy)event.getThrowableProxy();
        if (info != null) {
            Throwable exception = info.getThrowable();
            String message = event.getFormattedMessage();
            if (message != null) {
                logEvent.setTitle(message);
                logEvent.setMessage(Strings.toString((Throwable)exception));
            }
        }
        if (logEvent.getMessage() == null) {
            logEvent.setMessage("");
        }
        return logEvent;
    }

    private LogLevel convertLevel2LogLevel(Level level) {
        LogLevel logLevel = LogLevel.DEBUG;
        switch (level.levelInt) {
            case 0x7FFFFFFF: {
                logLevel = LogLevel.FATAL;
                break;
            }
            case 40000: {
                logLevel = LogLevel.ERROR;
                break;
            }
            case 20000: {
                logLevel = LogLevel.INFO;
                break;
            }
            case 10000: {
                logLevel = LogLevel.DEBUG;
            }
        }
        return logLevel;
    }
}

