/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.log.ILogSender;
import com.beast.clog.agent.log.impl.CLoggingLogSender;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.TraceManager;
import com.beast.clog.common.utils.IdentityUtil;
import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.LogLevel;
import com.beast.clog.models.thrift.LogType;
import java.util.Optional;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang3.BooleanUtils;

public class ClogBeastRootAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    ILogSender logSender;
    private static Boolean initSuccess = false;
    private static CircularFifoQueue<ILoggingEvent> cacheLoggingEvent = new CircularFifoQueue(1000);

    protected void append(ILoggingEvent event) {
        try {
            ILogSender sender;
            if (this.canSend(event) && (sender = this.getLogSender()) != null) {
                sender.send(this.convertILoggingEvent2LogEvent(event));
            }
        }
        catch (Exception var4) {
            throw new LogbackException(event.getFormattedMessage(), (Throwable)var4);
        }
    }

    private ILogSender getLogSender() {
        if (this.logSender == null) {
            ITrace tracer = TraceManager.getTracer("logback-clog");
            this.logSender = new CLoggingLogSender(tracer);
            initSuccess = true;
        }
        return this.logSender;
    }

    private boolean canSend(ILoggingEvent event) {
        if (BooleanUtils.isFalse((Boolean)initSuccess)) {
            String propName = "com.thebeastshop.kit.prop.PropConfig";
            String preFix = "init properties";
            if (propName.equalsIgnoreCase(event.getLoggerName()) && event.getMessage().startsWith(preFix)) {
                initSuccess = true;
                for (ILoggingEvent iLoggingEvent : cacheLoggingEvent) {
                    this.append(iLoggingEvent);
                }
                while (!cacheLoggingEvent.isEmpty()) {
                    this.append((ILoggingEvent)cacheLoggingEvent.poll());
                }
            } else {
                cacheLoggingEvent.add((Object)event);
            }
        }
        return initSuccess;
    }

    private LogEvent convertILoggingEvent2LogEvent(ILoggingEvent event) {
        LogEvent logEvent = new LogEvent();
        logEvent.setId(IdentityUtil.getUniqueID());
        logEvent.setTitle(LogConfig.getInstance().getAppId() + "");
        logEvent.setLogLevel(this.convertLevel2LogLevel(event.getLevel()));
        logEvent.setLogType(LogType.APP);
        logEvent.setSource(event.getLoggerName());
        logEvent.setThreadId(Thread.currentThread().getId());
        logEvent.setCreatedTime(event.getTimeStamp());
        logEvent.setAttributes(null);
        logEvent.setMessage(Optional.ofNullable(event.getFormattedMessage()).orElse(""));
        ThrowableProxy info = (ThrowableProxy)event.getThrowableProxy();
        if (info != null) {
            Throwable exception = info.getThrowable();
            if (event.getFormattedMessage() != null) {
                logEvent.setTitle(event.getFormattedMessage());
                logEvent.setMessage(Strings.toString((Throwable)exception));
            }
        }
        return logEvent;
    }

    private LogLevel convertLevel2LogLevel(Level level) {
        LogLevel logLevel = LogLevel.INFO;
        switch (level.levelInt) {
            case 0x7FFFFFFF: {
                logLevel = LogLevel.FATAL;
                break;
            }
            case 40000: {
                logLevel = LogLevel.ERROR;
                break;
            }
            case 30000: {
                logLevel = LogLevel.WARN;
                break;
            }
            case 20000: {
                logLevel = LogLevel.INFO;
                break;
            }
            case 10000: {
                logLevel = LogLevel.DEBUG;
            }
        }
        return logLevel;
    }
}

