/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.utils;

import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.ExceptionType;
import com.beast.clog.models.thrift.LogEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class LogEventUtil {
    private static final int MAX_TITLE_SIZE = 200;
    private static final int MAX_KEY_SIZE = 32;
    private static final int MAX_VALUE_SIZE = 2048;
    private static final int MAX_ADDINFO_SIZE = 10;
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    private static String truncate(String value, int maxLength) {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return value.length() <= maxLength ? value : value.substring(0, maxLength);
    }

    public static void truncateLogSize(LogEvent logEvent, int size) {
        int maxMessageSize = size * 1024;
        logEvent.setTitle(LogEventUtil.truncate(logEvent.getTitle(), 200));
        logEvent.setMessage(LogEventUtil.truncate(logEvent.getMessage(), maxMessageSize));
        if (logEvent.getAttributes() != null && logEvent.getAttributes().size() > 0) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            int i = 0;
            for (String key : logEvent.getAttributes().keySet()) {
                if (++i > 10) break;
                String k = LogEventUtil.truncate(key, 32);
                String v = (String)logEvent.getAttributes().get(key);
                v = LogEventUtil.truncate(v, 2048);
                attrs.put(k, v);
            }
            logEvent.setAttributes(attrs);
        }
    }

    public static String toLogString(String loggerName, LogEvent logEvent) {
        StringBuffer data = new StringBuffer();
        if (logEvent.getCreatedTime() > 0L) {
            Date date = new Date(logEvent.getCreatedTime());
            data.append(df.format(date) + "|");
        }
        data.append(logEvent.getLogLevel().name());
        data.append("|" + Thread.currentThread().getName());
        data.append("|" + loggerName);
        if (logEvent.getAttributes() != null && logEvent.getAttributes().size() > 0) {
            String tag = "[";
            for (String key : logEvent.getAttributes().keySet()) {
                tag = tag + key + "=" + (String)logEvent.getAttributes().get(key) + ",";
            }
            tag = tag.substring(0, tag.length() - 1) + "]";
            data.append("|" + tag);
        }
        if (!Strings.isNullOrEmpty((String)logEvent.getTitle())) {
            data.append("|" + logEvent.getTitle());
        }
        if (!Strings.isNullOrEmpty((String)logEvent.getMessage())) {
            data.append("|" + logEvent.getMessage());
        }
        return data.toString();
    }

    @Deprecated
    public static long getSpanId(String className) {
        return className.startsWith("com.thebeastshop") ? ExceptionType.APPLICATION.value : ExceptionType.RUNTIME.value;
    }
}

