/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.config;

import com.beast.clog.common.configuration.Configuration;
import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.LogLevel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogConfig {
    private static Logger logger = Logger.getLogger(LogConfig.class.getName());
    private static LogConfig instance = new LogConfig();
    private volatile int appId;
    private volatile String environment;
    private volatile String environmentGroup;
    private volatile String brokerList = "114.55.236.27:9092,114.55.236.27:9093,114.55.236.27:9094";
    private volatile LogLevel level = LogLevel.INFO;
    private volatile boolean appLogEnabled = true;
    private volatile boolean traceEnabled = true;
    private volatile boolean metricsEnabled = true;
    private volatile short maxMessageSize = (short)32;
    private volatile int chunkSize = 50;
    private volatile int chunkInterval = 500;
    private volatile boolean appLocalLogEnabled = false;
    public static final String BROKER_LIST_KEY = "clog.kafka.cluster.address";
    private static final String LEVEL_KEY = "clog.log.level";
    private static final String APP_LOG_ENABLE_KEY = "clog.log.enable";
    private static final String APP_TRACE_ENABLE_KEY = "clog.trace.enable";
    private static final String APP_METRICS_ENABLE_KEY = "clog.metrics.enable";
    private static final String LOGGING_MAX_MESSAGE_SIZE_KEY = "clog.message.size";
    private static final String APP_CHUNK_SIZE_KEY = "clog.chunk.size";
    private static final String APP_CHUNK_INTERVAL_KEY = "clog.chunk.interval";
    private static final String APP_LOG_LOCAL_ENABLE_KEY = "clog.local.enable";

    public static LogConfig getInstance() {
        return instance;
    }

    private LogConfig() {
        this.init();
    }

    public int getAppId() {
        return this.appId;
    }

    public void setAppId(int appId) {
        this.appId = appId;
        if (this.appId > 0) {
            logger.info("clog.app.id: " + appId);
        } else {
            logger.warning("AppId can't be empty, pls check!!!!!!!!!!!");
        }
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getEnvironmentGroup() {
        return this.environmentGroup;
    }

    public void setEnvironmentGroup(String environmentGroup) {
        this.environmentGroup = environmentGroup;
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    private void setBrokerList(String brokerList) {
        if (Strings.isNullOrEmpty((String)brokerList)) {
            logger.log(Level.WARNING, "clog.kafka.cluster.address is empty, use default setting: " + this.brokerList);
        } else {
            this.brokerList = brokerList;
            logger.log(Level.WARNING, "clog.kafka.cluster.address has been updated to: " + brokerList);
        }
    }

    public LogLevel getLevel() {
        return this.level;
    }

    private void setLevel(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            logger.info("clog.log.level is empty, use default setting: INFO");
        } else {
            if (val.equalsIgnoreCase(LogLevel.INFO.toString())) {
                this.level = LogLevel.INFO;
                logger.info("clog.log.level has been updated to: INFO");
                return;
            }
            if (val.equalsIgnoreCase(LogLevel.DEBUG.toString())) {
                this.level = LogLevel.DEBUG;
                logger.info("clog.log.level has been updated to: DEBUG");
                return;
            }
            if (val.equalsIgnoreCase(LogLevel.ERROR.toString())) {
                this.level = LogLevel.ERROR;
                logger.info("clog.log.level has been updated to: ERROR");
                return;
            }
            if (val.equalsIgnoreCase(LogLevel.WARN.toString())) {
                this.level = LogLevel.WARN;
                logger.info("clog.log.level has been updated to: WARN");
                return;
            }
        }
    }

    public boolean isAppLogEnabled() {
        return Configuration.get((String)APP_LOG_ENABLE_KEY, (String)"true").equals("true");
    }

    private void setAppLogEnabled(String val) {
        if (Strings.isNullOrEmpty((String)val) || !val.equalsIgnoreCase("true") && val.equalsIgnoreCase("false")) {
            logger.log(Level.WARNING, "clog.log.enable update failed. invalid value: " + val + ", use default value: true");
            return;
        }
        this.appLogEnabled = Boolean.parseBoolean(val);
        logger.info("clog.log.enable has been updated to: " + val);
    }

    public boolean isTraceEnabled() {
        return Configuration.get((String)APP_TRACE_ENABLE_KEY, (String)"true").equals("true");
    }

    private void setTraceEnabled(String val) {
        if (Strings.isNullOrEmpty((String)val) || !val.equalsIgnoreCase("true") && val.equalsIgnoreCase("false")) {
            logger.log(Level.WARNING, "clog.trace.enable update failed. invalid value: " + val + ", use default value: true");
            return;
        }
        this.traceEnabled = Boolean.parseBoolean(val);
        logger.info("clog.trace.enable has been updated to: " + val);
    }

    public boolean isMetricsEnabled() {
        return Configuration.get((String)APP_METRICS_ENABLE_KEY, (String)"true").equals("true");
    }

    private void setMetricsEnabled(String val) {
        if (Strings.isNullOrEmpty((String)val) || !val.equalsIgnoreCase("true") && val.equalsIgnoreCase("false")) {
            logger.log(Level.WARNING, "clog.metrics.enable update failed. invalid value: " + val + ", use default value: true");
            return;
        }
        this.metricsEnabled = Boolean.parseBoolean(val);
        logger.info("clog.metrics.enable has been updated to: " + val);
    }

    public short getMaxMessageSize() {
        return this.maxMessageSize;
    }

    private void setMaxMessagesSize(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            logger.log(Level.WARNING, "clog.message.size is empty, use default setting: " + this.maxMessageSize + "KB");
            return;
        }
        short shortVal = 0;
        try {
            shortVal = Short.parseShort(val);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "clog.message.sizeupdate failed, parse short error.", e);
        }
        if (shortVal > 0) {
            this.maxMessageSize = shortVal;
            logger.info("clog.message.size has been updated to: " + shortVal);
        } else {
            logger.log(Level.WARNING, "clog.message.size update failed. invalid value: " + shortVal);
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    private void setChunkSize(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            logger.log(Level.WARNING, "clog.chunk.size is empty, use default setting: " + this.chunkSize);
            return;
        }
        int intVal = 0;
        try {
            intVal = Integer.parseInt(val);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "clog.chunk.size update failed, parse int error.", e);
        }
        if (intVal > 0) {
            this.chunkSize = intVal;
            logger.info("clog.chunk.size has been updated to: " + intVal);
        } else {
            logger.log(Level.WARNING, "clog.chunk.size update failed, invalid value: " + intVal);
        }
    }

    public int getChunkInterval() {
        return this.chunkInterval;
    }

    public void setChunkInterval(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            logger.log(Level.WARNING, "clog.chunk.interval is empty, use default setting: " + this.chunkInterval);
            return;
        }
        int intVal = 0;
        try {
            intVal = Integer.parseInt(val);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "clog.chunk.interval update failed, parse int error.", e);
        }
        if (intVal > 0) {
            this.chunkInterval = intVal;
            logger.info("clog.chunk.interval has been updated to: " + intVal);
        } else {
            logger.log(Level.WARNING, "clog.chunk.interval update failed, invalid value: " + intVal);
        }
    }

    public boolean isAppLocalLogEnabled() {
        return this.appLocalLogEnabled;
    }

    private void setAppLocalLogEnabled(String val) {
        if (Strings.isNullOrEmpty((String)val) || !val.equalsIgnoreCase("true") && val.equalsIgnoreCase("false")) {
            logger.log(Level.WARNING, "clog.local.enable update failed. invalid value: " + val + ", use default value: " + this.appLocalLogEnabled);
            return;
        }
        this.appLocalLogEnabled = Boolean.parseBoolean(val);
        logger.info("clog.local.enable has been updated to: " + val);
    }

    public void init() {
        logger.info("************** Begin to initialize clog agent setting **************");
        this.setAppId(Configuration.getAppId());
        this.setEnvironment(Configuration.getEnvironment());
        this.setEnvironmentGroup(Configuration.getEnvironmentGroup());
        this.setBrokerList(Configuration.get((String)BROKER_LIST_KEY));
        this.setLevel(Configuration.get((String)LEVEL_KEY));
        this.setAppLogEnabled(Configuration.get((String)APP_LOG_ENABLE_KEY));
        this.setTraceEnabled(Configuration.get((String)APP_TRACE_ENABLE_KEY));
        this.setMetricsEnabled(Configuration.get((String)APP_METRICS_ENABLE_KEY));
        this.setMaxMessagesSize(Configuration.get((String)LOGGING_MAX_MESSAGE_SIZE_KEY));
        this.setChunkSize(Configuration.get((String)APP_CHUNK_SIZE_KEY));
        this.setChunkInterval(Configuration.get((String)APP_CHUNK_INTERVAL_KEY));
        this.setAppLocalLogEnabled(Configuration.get((String)APP_LOG_LOCAL_ENABLE_KEY));
        logger.info("************** Initialize clog agent setting completed **************");
    }

    public boolean isInited() {
        return this.appId > 0 && !Strings.isNullOrEmpty((String)this.brokerList);
    }
}

