/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.trace.impl;

import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.trace.ISpan;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.impl.CommonTracer;
import com.beast.clog.agent.utils.RandomUtil;
import com.beast.clog.common.utils.HostUtil;
import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.Span;
import com.beast.clog.models.thrift.SpanType;
import java.util.Collections;
import java.util.List;

public class MilliSpan
implements ISpan {
    private final Span innerSpan = new Span();
    private final ISpan parent;
    private final CommonTracer tracer;

    public MilliSpan(String name, String serviceName, long id, ISpan parent, SpanType spanType, CommonTracer tracer) {
        if (Strings.isNullOrEmpty((String)name)) {
            this.innerSpan.setName("NoNameSpan");
        } else {
            this.innerSpan.setName(name);
        }
        if (Strings.isNullOrEmpty((String)serviceName)) {
            this.innerSpan.setServiceName("NoNameService");
        } else {
            this.innerSpan.setServiceName(serviceName);
        }
        this.innerSpan.setSpanId(id);
        this.innerSpan.setAppId(Integer.toString(LogConfig.getInstance().getAppId()));
        this.innerSpan.setSpanType(spanType);
        this.parent = parent;
        this.innerSpan.setParentId(this.getParentId());
        this.innerSpan.setTraceId(this.getTraceId());
        this.innerSpan.setStartTime(System.currentTimeMillis());
        this.innerSpan.setStopTime(0L);
        this.innerSpan.setHostIp(HostUtil.getHostIp());
        this.innerSpan.setHostName(HostUtil.getHostName());
        this.innerSpan.setUnfinished(false);
        this.innerSpan.setThreadId(Thread.currentThread().getId());
        this.tracer = tracer;
    }

    @Override
    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.innerSpan.setStopTime(System.currentTimeMillis());
        this.tracer.pop(this);
    }

    @Override
    public boolean isStopped() {
        return this.innerSpan.getStopTime() != 0L;
    }

    @Override
    public long getAccumulateMillis() {
        if (this.innerSpan.getStartTime() == 0L) {
            return 0L;
        }
        if (this.innerSpan.getStopTime() > 0L) {
            return this.innerSpan.getStopTime() - this.innerSpan.getStartTime();
        }
        return System.currentTimeMillis() - this.innerSpan.getStartTime();
    }

    @Override
    public boolean isRunning() {
        return this.innerSpan.getStartTime() != 0L && this.innerSpan.getStopTime() == 0L;
    }

    public String toString() {
        long parentId = this.getParentId();
        return "\"" + this.getDescription() + "\" trace:" + this.getTraceId() + " span:" + this.innerSpan.getSpanId() + (parentId > 0L ? " parent:" + parentId : "") + " start:" + this.innerSpan.getStartTime() + " ms " + Long.toString(this.getAccumulateMillis()) + (this.isRunning() ? "..." : "");
    }

    @Override
    public String getDescription() {
        return "[" + this.innerSpan.getServiceName() + " : " + this.innerSpan.getName() + "]";
    }

    @Override
    public long getSpanId() {
        return this.innerSpan.getSpanId();
    }

    @Override
    public ISpan getParent() {
        return this.parent;
    }

    @Override
    public long getTraceId() {
        return this.parent.getTraceId();
    }

    @Override
    public ISpan createChild(String name, String serviceName, SpanType spanType, ITrace tracer) {
        return new MilliSpan(name, serviceName, RandomUtil.nextLong(), this, spanType, (CommonTracer)tracer);
    }

    @Override
    public long getParentId() {
        return this.parent.getSpanId();
    }

    @Override
    public List<LogEvent> getLogEvents() {
        return Collections.unmodifiableList(this.innerSpan.getLogEvents());
    }

    public void addLogEvent(LogEvent logEvent) {
        if (logEvent == null) {
            return;
        }
        logEvent.setTraceId(this.getTraceId());
        this.innerSpan.addToLogEvents(logEvent);
    }

    @Override
    public SpanType getSpanType() {
        return this.innerSpan.getSpanType();
    }

    @Override
    public Span getInnerSpan() {
        return this.innerSpan;
    }

    @Override
    public long getStartTimeMillis() {
        return this.getInnerSpan().getStartTime();
    }

    @Override
    public long getStopTimeMillis() {
        return this.getInnerSpan().getStopTime();
    }
}

