/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring.configuration;

import com.beast.clog.agent.spring.TraceLogManager;
import com.beast.clog.agent.spring.TraceLogManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ObjectUtils;

@Configuration
public class TraceLogManagerConfiguration
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(TraceLogManagerConfiguration.class);
    Environment env;
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isRegisteredBean(TraceLogManager.class)) {
            return;
        }
        log.debug("register default traceLogManager");
        RootBeanDefinition beanDefinition = new RootBeanDefinition(TraceLogManagerImpl.class);
        MutablePropertyValues values = new MutablePropertyValues();
        values.addPropertyValue("slowTime", (Object)this.env.getProperty("trace.slowTime", "1000"));
        registry.registerBeanDefinition("traceLogManager", (BeanDefinition)beanDefinition);
    }

    private boolean isRegisteredBean(Class<?> beanClass) {
        return !ObjectUtils.isEmpty((Object[])BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, beanClass, (boolean)true, (boolean)false));
    }
}

