/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.works.producers;

import com.beast.clog.agent.Metrics;
import com.beast.clog.agent.works.events.TBaseEvent;
import com.lmax.disruptor.RingBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBaseEventProducer {
    private Logger logger = LoggerFactory.getLogger(TBaseEventProducer.class);
    private final RingBuffer<TBaseEvent> ringBuffer;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();

    public TBaseEventProducer(RingBuffer<TBaseEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TBase base) {
        int count = 0;
        try {
            long sequence;
            this.lock.lock();
            try {
                while (!this.ringBuffer.hasAvailableCapacity(1)) {
                    if (++count > 150) {
                        return;
                    }
                    if (count > 50) {
                        this.notFull.await(1L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    this.notFull.await();
                }
                sequence = this.ringBuffer.next();
            }
            finally {
                this.lock.unlock();
                this.notFull.signalAll();
            }
            try {
                TBaseEvent event = (TBaseEvent)this.ringBuffer.get(sequence);
                event.setBase(base);
            }
            finally {
                this.ringBuffer.publish(sequence);
                Metrics.instance().getPutQueueCounter().incrementAndGet();
            }
            return;
        }
        catch (InterruptedException e) {
            return;
        }
    }
}

