/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.utils;

import com.beast.clog.agent.utils.ServiceUtil;
import com.beast.clog.common.utils.Strings;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration {
    private static final String ENV_KEY = "env";
    private static final String APOLLO_CLUSTER = "apollo.cluster";
    private static final String ENV_LOCAL = "local";
    private static final String ENV_TEST = "test";
    private static final String ENV_PRE = "pre";
    private static final String ENV_PROD = "prod";
    private static final String APOLLO_FAT = "fat";
    private static final String APOLLO_UAT = "uat";
    private static final String APOLLO_PRO = "pro";
    private static final Logger logger = LoggerFactory.getLogger(ClientConfiguration.class);
    private static int appId = 0;

    private static String getMetaAppProperty(String name) {
        return ServiceUtil.getAppProperty(name);
    }

    private static String getPrioritizedProperty(Properties properties, String key) {
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isEmpty((CharSequence)(value = properties.getProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ServiceUtil.getServerSideAppProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ServiceUtil.getServerSideProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ClientConfiguration.getMetaAppProperty(key)))) {
            value = System.getenv(key);
        }
        return value;
    }

    private static String getApolloEnvName(String env) {
        if (ENV_TEST.equals(env)) {
            return APOLLO_FAT;
        }
        if (ENV_PRE.equals(env)) {
            return APOLLO_UAT;
        }
        if (ENV_PROD.equals(env)) {
            return APOLLO_PRO;
        }
        return env;
    }

    public static String getEnv(Properties properties) {
        String env = ClientConfiguration.getPrioritizedProperty(properties, ENV_KEY);
        if (StringUtils.isEmpty((CharSequence)env)) {
            return ENV_LOCAL;
        }
        return ClientConfiguration.getApolloEnvName(env);
    }

    public static String getApolloCluster(Properties properties) {
        String cluster = ClientConfiguration.getPrioritizedProperty(properties, APOLLO_CLUSTER);
        if (StringUtils.isNotBlank((CharSequence)cluster)) {
            return cluster.trim();
        }
        return null;
    }

    public static String get(Properties prop, String key) {
        return ClientConfiguration.getPrioritizedProperty(prop, key);
    }

    public static String get(Properties prop, String key, String defaultValue) {
        String val = ClientConfiguration.getPrioritizedProperty(prop, key);
        return val == null ? defaultValue : val;
    }

    public static int getAppId(Properties prop) {
        if (appId == 0) {
            String clogAppId = ClientConfiguration.get(prop, "clog.app.id");
            if (!Strings.isNullOrEmpty((String)clogAppId)) {
                appId = Integer.parseInt(clogAppId);
            } else {
                logger.error("clog.app.id \u672a\u914d\u7f6e");
            }
        }
        return appId;
    }

    public static boolean checkConfigReady(Properties prop) {
        String clogAppId = ClientConfiguration.get(prop, "clog.app.id");
        return clogAppId != null;
    }

    public static String getEnvironment() {
        String env = ClientConfiguration.getApolloCluster(System.getProperties());
        if (Strings.isNullOrEmpty((String)env)) {
            env = ClientConfiguration.getEnvironmentGroup();
        }
        return env;
    }

    public static String getEnvironmentGroup() {
        return ClientConfiguration.getEnv(System.getProperties());
    }
}

