/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring.utils;

import com.beast.clog.agent.spring.configuration.SimpleTraceConfiguration;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrettyFormat {
    private static ObjectMapper mapper = new ObjectMapper();
    private static Set<Class<?>> wrapperTypes = new HashSet();

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (SimpleTraceConfiguration.isPretty()) {
            String returnStr = value.toString();
            try {
                if (SimpleTraceConfiguration.isPretty()) {
                    returnStr = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return returnStr;
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            return "size=" + ((Collection)value).size();
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            return "size=" + ((Map)value).size();
        }
        if (value.getClass().isArray()) {
            return "size=" + Array.getLength(value);
        }
        if (wrapperTypes.contains(value.getClass())) {
            return value.toString();
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return (String)value;
        }
        return "<" + value.getClass().getSimpleName().toString() + ">";
    }

    public static void main(String[] args) {
        System.out.println(PrettyFormat.class.getCanonicalName());
    }

    static {
        wrapperTypes.add(Boolean.class);
        wrapperTypes.add(Character.class);
        wrapperTypes.add(Byte.class);
        wrapperTypes.add(Short.class);
        wrapperTypes.add(Integer.class);
        wrapperTypes.add(Long.class);
        wrapperTypes.add(Float.class);
        wrapperTypes.add(Double.class);
    }
}

