/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent;

import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.works.ClogThreadFactory;
import com.beast.clog.agent.works.events.KafkaEvent;
import com.beast.clog.agent.works.events.MetricsEvent;
import com.beast.clog.agent.works.events.TBaseEvent;
import com.beast.clog.agent.works.handler.KafkaEventHandler;
import com.beast.clog.agent.works.handler.MetricsEventHandler;
import com.beast.clog.agent.works.handler.TBaseEventHandler;
import com.beast.clog.agent.works.producers.KafkaMessageProducer;
import com.beast.clog.agent.works.producers.MetricsEventProducer;
import com.beast.clog.agent.works.producers.TBaseEventProducer;
import com.beast.clog.common.utils.HostUtil;
import com.beast.clog.models.thrift.Chunk;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentManager {
    private static AgentManager instance;
    private static Logger logger;
    private static final int NUM_EVENT_PROCESSORS = 3;
    private final ExecutorService executor = Executors.newFixedThreadPool(3, ClogThreadFactory.getInstance());
    private final RingBuffer<TBaseEvent> tbaseRingBuffer;
    private final RingBuffer<MetricsEvent> metricRingBuffer;
    private final RingBuffer<KafkaEvent> kafkaRingBuffer;
    private final SequenceBarrier tbaseSequenceBarrier;
    private final SequenceBarrier metricsSequenceBarrier;
    private final SequenceBarrier kafkaSequenceBarrier;
    private final TBaseEventProducer tbaseEventProducer;
    private final MetricsEventProducer metricsEventProducer;
    private final KafkaMessageProducer kafkaMessageProducer;
    private final TBaseEventHandler tbaseEventHandler;
    private final MetricsEventHandler metricsEventHandler;
    private final KafkaEventHandler kafkaEventHandler;
    private final BatchEventProcessor<TBaseEvent> tbaseBatchProcessor;
    private final BatchEventProcessor<MetricsEvent> metricsBatchProcessor;
    private final BatchEventProcessor<KafkaEvent> kafkaBatchProcessor;

    private AgentManager() {
        LogConfig config = LogConfig.getInstance();
        this.tbaseRingBuffer = RingBuffer.createSingleProducer(TBaseEvent.FACTORY, (int)config.getBaseBufferSize(), (WaitStrategy)new BlockingWaitStrategy());
        this.metricRingBuffer = RingBuffer.createMultiProducer(MetricsEvent.FACTORY, (int)config.getMetricsBufferSize(), (WaitStrategy)new BlockingWaitStrategy());
        this.kafkaRingBuffer = RingBuffer.createMultiProducer(KafkaEvent.FACTORY, (int)config.getKafkaBufferSize(), (WaitStrategy)new BlockingWaitStrategy());
        this.tbaseSequenceBarrier = this.tbaseRingBuffer.newBarrier(new Sequence[0]);
        this.metricsSequenceBarrier = this.metricRingBuffer.newBarrier(new Sequence[0]);
        this.kafkaSequenceBarrier = this.kafkaRingBuffer.newBarrier(new Sequence[0]);
        this.tbaseEventProducer = new TBaseEventProducer(this.tbaseRingBuffer);
        this.metricsEventProducer = new MetricsEventProducer(this.metricRingBuffer);
        this.kafkaMessageProducer = new KafkaMessageProducer(this.kafkaRingBuffer);
        this.tbaseEventHandler = new TBaseEventHandler(this.kafkaMessageProducer);
        this.metricsEventHandler = new MetricsEventHandler(this.kafkaMessageProducer);
        this.kafkaEventHandler = new KafkaEventHandler();
        this.tbaseBatchProcessor = new BatchEventProcessor(this.tbaseRingBuffer, this.tbaseSequenceBarrier, (EventHandler)this.tbaseEventHandler);
        this.metricsBatchProcessor = new BatchEventProcessor(this.metricRingBuffer, this.metricsSequenceBarrier, (EventHandler)this.metricsEventHandler);
        this.kafkaBatchProcessor = new BatchEventProcessor(this.kafkaRingBuffer, this.kafkaSequenceBarrier, (EventHandler)this.kafkaEventHandler);
        this.tbaseRingBuffer.addGatingSequences(new Sequence[]{this.tbaseBatchProcessor.getSequence()});
        this.metricRingBuffer.addGatingSequences(new Sequence[]{this.metricsBatchProcessor.getSequence()});
        this.kafkaRingBuffer.addGatingSequences(new Sequence[]{this.kafkaBatchProcessor.getSequence()});
        this.executor.submit((Runnable)this.tbaseBatchProcessor);
        this.executor.submit((Runnable)this.metricsBatchProcessor);
        this.executor.submit((Runnable)this.kafkaBatchProcessor);
        this.sendEnvironment();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AgentManager.this.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<AgentManager> clazz = AgentManager.class;
        synchronized (AgentManager.class) {
            if (instance == null) {
                instance = new AgentManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void sendEnvironment() {
        if (LogConfig.getInstance().getEnvironmentGroup() == "local") {
            if (LogConfig.getInstance().isAppLocalLogEnabled()) {
                this.kafkaMessageProducer.setData("beast.clog.env", this.tbaseEventHandler.serializer(this.getEnvironmentChunk()));
            }
        } else {
            this.kafkaMessageProducer.setData("beast.clog.env", this.tbaseEventHandler.serializer(this.getEnvironmentChunk()));
        }
    }

    private Chunk getEnvironmentChunk() {
        Chunk chunk = new Chunk();
        chunk.setEnvGroup(LogConfig.getInstance().getEnvironmentGroup());
        chunk.setEnv(LogConfig.getInstance().getEnvironment());
        chunk.setHostIp(HostUtil.getHostIp());
        chunk.setHostName(HostUtil.getHostName());
        chunk.setAppId(LogConfig.getInstance().getAppId());
        chunk.setLogEvents(new LinkedList());
        chunk.setMetrics(new LinkedList());
        chunk.setSpans(new LinkedList());
        chunk.setEvents(new LinkedList());
        return chunk;
    }

    public TBaseEventProducer getMessageProducer() {
        return this.tbaseEventProducer;
    }

    public MetricsEventProducer getMetricsProducer() {
        return this.metricsEventProducer;
    }

    public void shutdown() {
        this.tbaseBatchProcessor.halt();
        this.metricsBatchProcessor.halt();
        this.kafkaBatchProcessor.halt();
        this.executor.shutdown();
        while (true) {
            if (this.executor.isTerminated()) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.tbaseEventHandler.shutdown();
        this.metricsEventHandler.shutdown();
        this.kafkaEventHandler.shutdown();
        logger.log(Level.INFO, "clog agent has been shutdown");
    }

    public void shutdownNow() {
        this.tbaseBatchProcessor.halt();
        this.metricsBatchProcessor.halt();
        this.kafkaBatchProcessor.halt();
        this.executor.shutdown();
        this.tbaseEventHandler.shutdown();
        this.metricsEventHandler.shutdown();
        this.kafkaEventHandler.shutdown();
        logger.log(Level.INFO, "clog agent has been shutdown");
    }

    static {
        logger = Logger.getLogger(AgentManager.class.getName());
    }
}

