/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring;

import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.LogManager;
import com.beast.clog.agent.spring.ErrorLogType;
import com.beast.clog.agent.spring.TraceLogInfoThreadLocalManager;
import com.beast.clog.agent.spring.TraceLogManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class TraceLogManagerImpl
implements TraceLogManager {
    public static final String TRACE = "TRACE";
    public static final String APP_ERROR = "APP_ERROR";
    public static final String USER_ERROR = "USER_ERROR";
    public static final String SLOW_LOGIC = "SLOW_LOGIC";
    private static final ILog log = LogManager.getLogger(TraceLogManagerImpl.class);
    private static final ILog traceLog = LogManager.getLogger("TRACE");
    private static final ILog appErrorLog = LogManager.getLogger("APP_ERROR");
    private static final ILog userErrorLog = LogManager.getLogger("USER_ERROR");
    private static final ILog slowLog = LogManager.getLogger("SLOW_LOGIC");
    private long slowTime = 1000L;

    @Override
    public void setSlowTime(long slowTime) {
        log.info("slowTime = " + slowTime + " (ms)");
        this.slowTime = slowTime;
    }

    @Override
    public void writeStartLog(String message) {
        TraceLogInfoThreadLocalManager.addDepth();
        if (TraceLogInfoThreadLocalManager.isFirstDepth()) {
            this.startTime();
        }
        String depthMessage = this.addStartSpace() + message;
        traceLog.info(depthMessage);
        TraceLogInfoThreadLocalManager.addLog(depthMessage);
    }

    @Override
    public void writeEndLog(String message) {
        String depthMessage = this.addEndSpace() + message;
        traceLog.info(depthMessage);
        TraceLogInfoThreadLocalManager.addLog(depthMessage);
        if (TraceLogInfoThreadLocalManager.isFirstDepth()) {
            this.profile();
            this.clear();
        } else {
            TraceLogInfoThreadLocalManager.removeDepth();
        }
    }

    @Override
    public void writeExceptionLog(String message, Throwable ex) {
        String depthMessage = this.addExceptionSpace() + message;
        traceLog.info(depthMessage);
        TraceLogInfoThreadLocalManager.addLog(depthMessage);
        if (TraceLogInfoThreadLocalManager.isFirstDepth()) {
            this.setException(ex);
            this.profile();
            this.clear();
        } else {
            TraceLogInfoThreadLocalManager.removeDepth();
        }
    }

    private void clear() {
        TraceLogInfoThreadLocalManager.clear();
    }

    private void profile() {
        String result;
        long responseTime = this.getResponseTime();
        if (responseTime >= this.slowTime) {
            result = this.buildTrace();
            slowLog.error(result);
        }
        if (this.getException() == null) {
            return;
        }
        if (this.getErrorLogType() == ErrorLogType.USER_ERROR) {
            result = this.buildTraceAndExceptionLog();
            userErrorLog.info(result);
        } else if (this.getErrorLogType() == ErrorLogType.APP_ERROR) {
            result = this.buildTraceAndExceptionLog();
            appErrorLog.error(result);
        }
    }

    private String buildTrace() {
        StringBuilder sb = new StringBuilder();
        this.buildTraceLog(sb);
        return sb.toString();
    }

    private String buildTraceAndExceptionLog() {
        StringBuilder sb = new StringBuilder();
        this.buildTraceLog(sb);
        if (this.getException() != null) {
            this.buildExceptionLog(sb);
        }
        return sb.toString();
    }

    private void buildTraceLog(StringBuilder sb) {
        sb.append("TRACE LOG").append("\n");
        List<String> logs = TraceLogInfoThreadLocalManager.getLogs();
        for (int i = 0; i < logs.size(); ++i) {
            String s = logs.get(i);
            sb.append(s);
            if (i >= logs.size() - 1) continue;
            sb.append("\n");
        }
    }

    private void buildExceptionLog(StringBuilder sb) {
        if (this.getException() != null) {
            sb.append("[EXCEPTION] ").append(this.getExceptionTrace());
        }
    }

    protected String addStartSpace() {
        return this.addSpace("-->");
    }

    protected String addEndSpace() {
        return this.addSpace("<--");
    }

    protected String addExceptionSpace() {
        return this.addSpace("<X-");
    }

    private String addSpace(String prefix) {
        Integer depth = TraceLogInfoThreadLocalManager.getDepth();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < depth; ++i) {
            sb.append(i == depth - 1 ? "|" + prefix : "|   ");
        }
        return sb.toString();
    }

    @Override
    public void setException(Throwable ex) {
        TraceLogInfoThreadLocalManager.setException(ex);
    }

    @Override
    public Throwable getException() {
        return TraceLogInfoThreadLocalManager.getException();
    }

    private void startTime() {
        TraceLogInfoThreadLocalManager.startTime();
    }

    @Override
    public long getResponseTime() {
        return System.currentTimeMillis() - TraceLogInfoThreadLocalManager.getTime();
    }

    @Override
    public void setErrorLogType(ErrorLogType type) {
        TraceLogInfoThreadLocalManager.setErrorLogType(type);
    }

    @Override
    public ErrorLogType getErrorLogType() {
        return TraceLogInfoThreadLocalManager.getErrorLogType();
    }

    private String getExceptionTrace() {
        Throwable e = this.getException();
        if (e == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        if (e.getMessage() != null) {
            sw.write(e.getMessage());
        }
        sw.write("; trace=");
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

