/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.log.impl;

import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.log.ILogSender;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.LogLevel;

public class CLoggingLogSender
implements ILogSender {
    private ITrace tracer;

    public CLoggingLogSender(ITrace tracer) {
        this.tracer = tracer;
    }

    @Override
    public void send(LogEvent logEvent) {
        if (LogConfig.getInstance().isAppLogEnabled() && this.isLogLevelEnabled(logEvent.getLogLevel())) {
            this.tracer.log(logEvent);
        }
    }

    private boolean isLogLevelEnabled(LogLevel level) {
        return level.getValue() >= LogConfig.getInstance().getLevel().getValue();
    }
}

