/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.log;

import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.impl.CLoggingLogSender;
import com.beast.clog.agent.log.impl.CLoggingLogger;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.TraceManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogManager {
    private static Map<String, ILog> _loggers = new ConcurrentHashMap<String, ILog>();

    private LogManager() {
    }

    public static ILog getLogger(Class<?> type) {
        if (type == null) {
            return LogManager.getLogger("defaultLogger");
        }
        return LogManager.getLogger(type.getName());
    }

    public static ILog getLogger(String name) {
        ILog logger;
        String loggerName = name;
        if (name == null || name.isEmpty()) {
            loggerName = "defaultLogger";
        }
        if ((logger = _loggers.get(loggerName)) == null) {
            ITrace tracer = TraceManager.getTracer(loggerName);
            CLoggingLogSender logSender = new CLoggingLogSender(tracer);
            logger = new CLoggingLogger(loggerName, logSender);
            _loggers.put(loggerName, logger);
        }
        return logger;
    }
}

