/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.thirdparty.weixin.api;

import com.thebeastshop.thirdparty.kit.HttpKit;
import com.thebeastshop.thirdparty.kit.ParamKit;
import com.thebeastshop.thirdparty.kit.StrKit;
import com.thebeastshop.thirdparty.weixin.api.SnsAccessToken;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SnsAccessTokenApi {
    private static String url = "https://api.weixin.qq.com/sns/oauth2/access_token?grant_type=authorization_code";
    private static String qrconnect_url = "https://open.weixin.qq.com/connect/qrconnect";

    public static String getQrConnectURL(String appId, String redirect_uri) {
        return SnsAccessTokenApi.getQrConnectURL(appId, redirect_uri, null);
    }

    public static String getQrConnectURL(String appId, String redirect_uri, String state) {
        try {
            redirect_uri = ParamKit.urlEncode(redirect_uri);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", appId);
        params.put("response_type", "code");
        params.put("redirect_uri", redirect_uri);
        params.put("scope", "snsapi_login");
        if (StrKit.isBlank(state)) {
            params.put("state", "wx#wechat_redirect");
        } else {
            params.put("state", state.concat("#wechat_redirect"));
        }
        String para = ParamKit.packageQueryString(params);
        return qrconnect_url + "?" + para;
    }

    public static SnsAccessToken getSnsAccessToken(String appId, String secret, String code) {
        Map<String, String> queryParas = ParamKit.create("appid", appId).put("secret", secret).put("code", code).getData();
        String json = HttpKit.get(url, queryParas);
        return new SnsAccessToken(json);
    }
}

